package com.bcxin.rest.web.apis.configs;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * @author linqinglin
 * @date 2022/2/10 11:03
 */
public class BJSSOConfig {

    public static String redirectUrl;

    static{
        if(redirectUrl == null) {
            ResourceBundle rb = ResourceBundle.getBundle("yzt_deploy", Locale.getDefault());
            String yzt_sso_auth_url = rb.getString("yzt_sso_auth_url");
            String yzt_sso_auth_redirect_url = rb.getString("yzt_sso_auth_redirect_url");
            String client_id = rb.getString("client_id");
            String service = rb.getString("service");
            String scope = rb.getString("scope");
            StringBuilder builder = new StringBuilder(yzt_sso_auth_url);
            builder.append("/oauth2/authorize?service=" + service);
            builder.append("&response_type=code&client_id=" + client_id);
            builder.append("&scope=" + scope);
            try {
                builder.append("&state=v5&redirect_uri="+URLEncoder.encode(yzt_sso_auth_redirect_url,"UTF-8") );
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            redirectUrl = builder.toString();
        }
    }
}
