package com.bcxin.tenant.domain.v5.services.impls;

import com.bcxin.tenant.domain.v5.entities.TDepartmentEntity;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentRepository;
import com.bcxin.tenant.domain.v5.services.TDepartmentService;
import com.bcxin.tenant.domain.v5.services.commands.SyncDepartmentCommand;
import org.springframework.stereotype.Service;

@Service
public class TDepartmentServiceImpl implements TDepartmentService {
    private final TDepartmentRepository departmentRepository;

    public TDepartmentServiceImpl(TDepartmentRepository departmentRepository) {
        this.departmentRepository = departmentRepository;
    }

    @Override
    public void create(SyncDepartmentCommand command) {
        this.departmentRepository.save(
                TDepartmentEntity.create(command.getId(), command.getName(),
                        command.getSuperior(), command.getDomainId(),command.getLevel()));
    }

    @Override
    public void update(SyncDepartmentCommand command) {
        TDepartmentEntity department = this.departmentRepository.getById(command.getId());
        if (department == null) {
            this.create(command);
        } else {
            department.change(command.getName(), command.getSuperior());
        }
    }
}
