package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.events.OrganizationCreatedEvent;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchRequestAbstract;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchType;
import com.bcxin.tenant.domain.v5.dispatches.requests.DomainDispatchRequest;
import com.bcxin.tenant.domain.v5.services.TDomainService;
import com.bcxin.tenant.domain.v5.services.commands.SyncDomainCommand;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DomainValueSnapshot;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class V5OrganizationCreatedEventHandler extends DomainEventHandlerAbstract<OrganizationCreatedEvent> {
    private final TDomainService domainService;

    public V5OrganizationCreatedEventHandler(TDomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    protected void execute(OrganizationCreatedEvent event) {
        String id = event.getData().getId();
        String name = event.getName();
        Map<String,String> dynamic = event.getDynamic();

        this.domainService.update(SyncDomainCommand.create(id, name,dynamic));
    }
}