package com.bcxin.tenant.domain.v5.dispatches.requests;

import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.UserValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueRemovedSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueSnapshot;

public class UserDispatchRequest extends DispatchRequestAbstract {
    private UserDispatchRequest(DispatchType dispatchType, ValueSnapshot userValueSnapshot) {
        super(dispatchType, userValueSnapshot);
    }

    @Override
    public String getConfigKey() {
        return "user";
    }

    public static UserDispatchRequest create(DispatchType dispatchType, UserValueSnapshot userValueSnapshot) {
        return new UserDispatchRequest(dispatchType, userValueSnapshot);
    }

    public static UserDispatchRequest createDeleted(ValueRemovedSnapshot valueRemovedSnapshot) {
        return new UserDispatchRequest(DispatchType.Deleted, valueRemovedSnapshot);
    }
}
