/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="t_user_department_role_set")
@Entity
public class TDepartmentUserEntity
extends EntityAbstract {
    @Id
    @Column(name="id")
    private String id;
    @Column(name="DEPARTMENTID")
    private String departmentId;
    @Column(name="USERID")
    private String userId;
    @Column(name="ROLEID", length=255)
    private String roleId;

    public void change(String departmentId, String roleId) {
        this.setRoleId(roleId);
        this.setDepartmentId(departmentId);
    }

    protected TDepartmentUserEntity() {
    }

    public static TDepartmentUserEntity create(String departmentId, String userId) {
        TDepartmentUserEntity departmentUser = new TDepartmentUserEntity();
        departmentUser.setId(String.format("T%s-%s", userId, UUIDUtil.getShortUuid()));
        departmentUser.setDepartmentId(departmentId);
        departmentUser.setUserId(userId);
        return departmentUser;
    }

    public void assignRole(String roleId) {
        this.setRoleId(roleId);
    }

    public void assignDepartId(String departmentId) {
        this.setDepartmentId(departmentId);
    }

    public String getId() {
        return this.id;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    protected void setUserId(String userId) {
        this.userId = userId;
    }

    protected void setRoleId(String roleId) {
        this.roleId = roleId;
    }
}

