/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.MemberType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.identities.requests.ChangeBasicIdentityRequest;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialsEntity;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.v5.entities.TDepartmentUserEntity;
import com.bcxin.tenant.domain.v5.entities.TUserEntity;
import com.bcxin.tenant.domain.v5.enums.IdCardType;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentRepository;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentUserRepository;
import com.bcxin.tenant.domain.v5.repositories.TUserRepository;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.ClearUserRoleCommand;
import com.bcxin.tenant.domain.v5.services.commands.SyncMemberCommand;
import com.bcxin.tenant.domain.v5.services.commands.SyncUserCommand;
import com.bcxin.tenant.domain.v5.services.commands.SyncUserRoleCommand;
import com.bcxin.tenant.domain.v5.services.commands.UpdateUserCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TUserServiceImpl
implements TUserService {
    private static final Logger logger = LoggerFactory.getLogger(TUserServiceImpl.class);
    private final TUserRepository userRepository;
    private final TDepartmentUserRepository departmentUserRepository;
    private final TDepartmentRepository tDepartmentRepository;
    private final TenantDbReader dbReader;
    private final UnitWork unitWork;

    public TUserServiceImpl(TUserRepository userRepository, TDepartmentUserRepository departmentUserRepository, TDepartmentRepository tDepartmentRepository, TenantDbReader dbReader, UnitWork unitWork) {
        this.userRepository = userRepository;
        this.departmentUserRepository = departmentUserRepository;
        this.tDepartmentRepository = tDepartmentRepository;
        this.dbReader = dbReader;
        this.unitWork = unitWork;
    }

    @Override
    public void create(SyncUserCommand command) {
        TUserEntity tUser = TUserEntity.create(command.getId(), command.getName(), command.getLoginNo(), command.getDomainId(), command.getTelephone());
        tUser.changeNumber(command.getCredentialType() == null ? "" : command.getCredentialType().name(), command.getCredentialNumber());
        String defaultDepartId = tUser.getDefaultDepartId();
        if (!CollectionUtils.isEmpty(command.getDepartmentIds())) {
            defaultDepartId = command.getDepartmentIds().stream().findFirst().get();
        }
        tUser.change(defaultDepartId, command.getIsDomainAdmin() == TrueFalseStatus.True);
        this.unitWork.executeTran(() -> {
            this.userRepository.save((Object)tUser);
            if (command.getDepartmentIds() != null) {
                Collection departmentUsers = command.getDepartmentIds().stream().map(ii -> TDepartmentUserEntity.create(ii, tUser.getId())).collect(Collectors.toList());
                this.departmentUserRepository.saveAll(departmentUsers);
            }
        });
    }

    @Override
    public void update(SyncUserCommand command) {
        TUserEntity tUser = (TUserEntity)((Object)this.userRepository.getById(command.getId()));
        if (tUser == null) {
            this.create(command);
        } else {
            tUser.change(command.getName(), command.getLoginNo());
        }
        this.unitWork.executeTran(() -> this.userRepository.save((Object)tUser));
    }

    @Override
    public void dispatch(SyncUserRoleCommand command) {
        if (!command.isFromAdmin()) {
            throw new NotAllowedTenantException("\u975e\u7ec4\u7ec7\u6216\u8005\u90e8\u95e8\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        if (TenantContext.getInstance().getUserContext().get() != null && command.getEmployeeIds().stream().anyMatch(ix -> ix.equalsIgnoreCase(TenantContext.getInstance().getUserContext().get().getEmployeeId()))) {
            throw new NotAllowedTenantException("\u4e0d\u5141\u8bb8\u66f4\u6539\u81ea\u5df1\u7684\u5e94\u7528\u6743\u9650");
        }
        command.validate();
        Collection<TDepartmentUserEntity> departmentUserEntities = this.departmentUserRepository.getByOrganIdAndUserIds(command.getOrganizationId(), command.getEmployeeIds());
        Collection employeeDepartIds = this.dbReader.getEmployeeDepartIds(command.getOrganizationId(), command.getEmployeeIds());
        this.unitWork.executeTran(() -> command.getEmployeeIds().forEach(ei -> {
            Optional<String> departIdOptional = employeeDepartIds.stream().filter(ix -> ix.getEmployeeId().equals(ei)).map(ii -> ii.getDepartId()).findFirst();
            if (!departIdOptional.isPresent()) {
                throw new NotFoundTenantException(String.format("\u6570\u636e\u5f02\u5e38, \u8be5\u7528\u6237(%s)\u672a\u5206\u914d\u90e8\u95e8\uff0c\u65e0\u6cd5\u8fdb\u884c\u89d2\u8272\u6388\u6743", ei));
            }
            String departId = departIdOptional.get();
            ArrayList<String> roleIds = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(command.getRoleIds())) {
                roleIds.addAll(command.getRoleIds());
            }
            Collection notExistsRoleIds = roleIds.stream().filter(ix -> !departmentUserEntities.stream().anyMatch(ii -> StringUtils.hasLength((String)ii.getRoleId()) && ii.getRoleId().equals(ix))).collect(Collectors.toList());
            for (String rId : notExistsRoleIds) {
                TDepartmentUserEntity tDepartmentUser = TDepartmentUserEntity.create(departId, ei);
                tDepartmentUser.change(departId, rId);
                this.departmentUserRepository.save((Object)tDepartmentUser);
            }
            Collection toBeRemovedEntities = departmentUserEntities.stream().filter(ix -> !roleIds.contains(ix.getRoleId())).collect(Collectors.toList());
            this.departmentUserRepository.deleteAll(toBeRemovedEntities);
        }));
    }

    @Override
    public void dispatch(ClearUserRoleCommand command) {
        command.validate();
        this.unitWork.executeTran(() -> this.departmentUserRepository.deleteByOrganIdAndUserId(command.getOrganizationId(), command.getId()));
    }

    @Override
    public void dispatch(UpdateUserCommand command) {
        command.validate();
        EmployeeEntity employee = command.getEmployee();
        String id = employee.getId();
        Optional userEntityOptional = this.userRepository.findById(id);
        String defaultDepartId = null;
        if (employee.getDefaultDepartment() != null) {
            defaultDepartId = employee.getDefaultDepartment().getId();
        }
        String organId = employee.getOrganization().getId();
        if (!userEntityOptional.isPresent()) {
            if (command.getEmployee().getStatus() == EmploymentStatus.OnJob) {
                TenantUserCredentialsEntity userCredentials = employee.getTenantUser().getSelectedCredential();
                this.create(SyncUserCommand.create(employee.getId(), employee.getTenantUser().getName(), employee.getTenantUser().getSelectIdNum(), organId, employee.getMasterSlaveType(), StringUtils.hasLength((String)defaultDepartId) ? Collections.singleton(defaultDepartId) : null, userCredentials == null ? CredentialType.IdCard : userCredentials.getCredentialType(), userCredentials == null ? "" : userCredentials.getNumber(), employee.getDomainAdmin(), employee.getTenantUser().getTelephone()));
            }
            return;
        }
        TUserEntity entity = (TUserEntity)((Object)userEntityOptional.get());
        String finalDefaultDepartId = defaultDepartId;
        this.unitWork.executeTran(() -> {
            if (command.getEmployee().getStatus() == EmploymentStatus.OffJob) {
                entity.markDeleted();
            } else {
                Collection<TDepartmentUserEntity> departmentUsers;
                entity.markUnDeleted();
                entity.change(employee.getTenantUser().getName(), employee.getTenantUser().getTelephone());
                entity.change(finalDefaultDepartId, employee.getDomainAdmin() == TrueFalseStatus.True);
                TenantUserCredentialsEntity credentials = employee.getTenantUser().getSelectedCredential();
                if (credentials != null) {
                    entity.changeNumber(credentials.getCredentialType().name(), credentials.getNumber());
                }
                if ((departmentUsers = this.departmentUserRepository.getByIds(organId, Collections.singleton(employee.getId()))).size() > 0) {
                    departmentUsers.stream().forEach(di -> di.assignDepartId(finalDefaultDepartId));
                } else {
                    departmentUsers.add(TDepartmentUserEntity.create(finalDefaultDepartId, employee.getId()));
                }
                this.departmentUserRepository.saveAll(departmentUsers);
            }
            this.userRepository.save((Object)entity);
        });
    }

    @Override
    public void changeBasic(ChangeBasicIdentityRequest changeBasicIdentityRequest) {
        Collection<TUserEntity> list = this.userRepository.getByLoginNo(changeBasicIdentityRequest.getOldPhone());
        if (list.size() > 0) {
            for (TUserEntity tUserEntity : list) {
                tUserEntity.change(changeBasicIdentityRequest.getName(), changeBasicIdentityRequest.getTelephone());
            }
            this.userRepository.saveAll(list);
        }
    }

    @Override
    public void dispatch(SyncMemberCommand command) {
        try {
            String defaultDepartId = this.tDepartmentRepository.getTop1ByOrganId(command.getOrganizationId());
            this.unitWork.executeTran(() -> {
                TUserEntity tUser = TUserEntity.create(command.getId(), command.getName(), command.getId(), command.getOrganizationId(), command.getTelephone());
                boolean domainAdmin = command.getMemberType() == MemberType.Master;
                tUser.change(defaultDepartId, domainAdmin);
                tUser.changeNumber(IdCardType.IdCard.getText(), "--");
                this.userRepository.save((Object)tUser);
            });
        }
        catch (Exception ex) {
            logger.error("\u540c\u6b65\u56e2\u961f\u6210\u5458(id={},name={},orgId={})\u53d1\u751f\u5f02\u5e38", new Object[]{command.getId(), command.getName(), command.getOrganizationId(), ex});
        }
    }
}

