package com.bcxin.api.interfaces.tenants.requests.tenantUsers;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Date;

@Getter
public class UpdateCredentialRequest extends RequestAbstract {
    @ApiModelProperty(value = "证件类型")
    private final CredentialType credentialType;
    @ApiModelProperty(value = "姓名")
    private final String name;
    @ApiModelProperty(value = "人头像")
    private final String headPhoto;

    @ApiModelProperty(value = "证件号码")
    private final String number;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateFrom;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateTo;

    @ApiModelProperty(value = "身份证人像面")
    private final String frontPhoto;

    @ApiModelProperty(value = "身份证国徽面")
    private final String reversePhoto;

    @ApiModelProperty(value = "地址")
    private final String address;

    @ApiModelProperty(value = "活体采集照片")
    private final String certificateImage;
    
    @ApiModelProperty(value = "是否来自企业端")
    private final boolean fromMobile;

    @ApiModelProperty(value = "确认实名认证;陕西的传true")
    private final boolean checkAuthenticate;

    public UpdateCredentialRequest(CredentialType credentialType,
                                   String name, String headPhoto,
                                   String number, Date validDateFrom, Date validDateTo,
                                   String frontPhoto, String reversePhoto,
                                   String address, String certificateImage,
                                   boolean checkAuthenticate,
                                   boolean fromMobile) {
        this.credentialType = credentialType;
        this.name = name;
        this.headPhoto = headPhoto;
        this.number = number;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.certificateImage = certificateImage;
        this.fromMobile = fromMobile;
        this.checkAuthenticate = checkAuthenticate;
    }
}
