package com.bcxin.api.interfaces.tenants.requests.organizations;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("地址信息")
@Data
public class LocationRequest implements Serializable {
    /**
     * 省份
     */
    @ApiModelProperty(value = "省份")
    private ItemValueRequest province;

    /**
     * 城市
     */
    @ApiModelProperty(value = "城市")
    private ItemValueRequest city;

    /**
     * 区域
     */
    @ApiModelProperty(value = "区域")
    private ItemValueRequest district;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址")
    private String address;


    @Data
    public static class ItemValueRequest  implements Serializable {
        @ApiModelProperty(value = "编码")
        private String code;
        @ApiModelProperty(value = "名称")
        private String name;

        public ItemValueRequest(){}
        public ItemValueRequest(String code, String name){
            this.code = code;
            this.name = name;
        }

        public static ItemValueRequest create(String code, String name) {
            return new ItemValueRequest(code,name);
        }
    }

    public LocationRequest(){}
    public LocationRequest(ItemValueRequest province, ItemValueRequest city, ItemValueRequest district, String address){
        this.province = province;
        this.city = city;
        this.district = district;
        this.address = address;
    }


    public static LocationRequest create(ItemValueRequest province, ItemValueRequest city, ItemValueRequest district, String address) {
        return new LocationRequest(province,city,district,address);
    }

    private static LocationRequest _EMPTY_VALUE = new LocationRequest();
    public static LocationRequest createEmpty() {
        return _EMPTY_VALUE;
    }
}
