package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@ApiModel("企业注册信息请求对象")
@Data
public class CompanyRegistrationRequest extends RequestAbstract {

    @ApiModelProperty(value = "电子政务number")
    private String number;

    @ApiModelProperty(value = "分享单位id")
    private String shareOrganizationId;

    @ApiModelProperty(value = "分享职员id")
    private String shareEmployeeId;

    @ApiModelProperty(value = "分享单位名称", hidden = true)
    private String shareOrganizationName;

    @ApiModelProperty(value = "分享职员姓名", hidden = true)
    private String shareEmployeeName;

    @ApiModelProperty(value = "行业类型", required = true)
    @NotBlank(message = "行业类型不能为空")
    private String industryCode;

    @ApiModelProperty(value = "机构类型", required = true)
    @NotBlank(message = "机构类型不能为空")
    private String institutionalCode;

    @ApiModelProperty(value = "保安服务公司类型（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.IndustryDetailType")
    private IndustryDetailType industryDetailType;


    //基本信息
    @ApiModelProperty(value = "公司名称", required = true)
    @NotBlank(message = "公司名称不能为空")
    private String name;

    @ApiModelProperty(value = "总/分/子公司", notes = "com.bcxin.Infrastructures.enums.ParentSubsidiary")
    private ParentSubsidiary type;

    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ApiModelProperty(value = "经济类型", notes = "com.bcxin.Infrastructures.enums.EconomicType")
    private EconomicType economicType;

    @ApiModelProperty(value = "公司类型", notes = "com.bcxin.Infrastructures.enums.CompanyNature")
    private CompanyNature nature;

    @ApiModelProperty(value = "注册地区", required = true)
    private LocationRequest placeOfRegister;

    @ApiModelProperty(value = "经营地区", required = true)
    private LocationRequest placeOfBusiness;


    //总公司信息，保安行业必填
    @ApiModelProperty(value = "总公司名称（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentName;

    @ApiModelProperty(value = "总公司证件类型（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private CompanyCertificateType parentCertificateType;

    @ApiModelProperty(value = "总公司证件号码（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentCertificateNumber;

    @ApiModelProperty(value = "总公司法人姓名（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentLegalPersonName;

    @ApiModelProperty(value = "总公司联系电话（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentLegalPersonTelephone;


    //法人或负责人信息
    @ApiModelProperty(value = "法人姓名", required = true)
    private String legalPersonName;

    @ApiModelProperty(value = "法人手机号码", required = true)
    private String legalPersonTelephone;

    @ApiModelProperty(value = "法人证件类型", required = true, notes = "com.bcxin.Infrastructures.enums.CredentialType")
    private CredentialType legalPersonCredentialType;

    @ApiModelProperty(value = "法人证件号码", required = true)
    private String legalPersonCredentialNumber;

    @ApiModelProperty(value = "法人国籍")
    private String legalPersonNationality;

    //保安负责人信息
    @ApiModelProperty(value = "保安负责人姓名")
    private String securityPersonName;

    @ApiModelProperty(value = "保安负责人手机号码")
    private String securityPersonTelephone;

    @ApiModelProperty(value = "保安负责人证件类型", notes = "com.bcxin.Infrastructures.enums.CredentialType")
    private CredentialType securityPersonCredentialType;

    @ApiModelProperty(value = "保安负责人证件号码")
    private String securityPersonCredentialNumber;


    //注册信息
    @ApiModelProperty(value = "注册资本（万元）")
    private String registeredCapital;

    @ApiModelProperty(value = "固定资产（万元，机构类型 = 保安服务公司 必填）")
    private String fixedCapital;

    @ApiModelProperty(value = "年营业额（万元，机构类型 = 保安服务公司 必填）")
    private String annualSalesVolume;

    @ApiModelProperty(value = "年利税（万元，机构类型 = 保安服务公司 必填）")
    private String annualProfitTax;

    @ApiModelProperty(value = "证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType", required = true)
    private CompanyCertificateType certificateType = CompanyCertificateType.UniformCreditCode;

    @ApiModelProperty(value = "统一社会信用代码", required = true)
    private String unifySocialCreditCode = "";

    @ApiModelProperty(value = "营业执照扫描件", required = true)
    private String unifySocialCreditCodeFile = "";


    //资质信息
    @ApiModelProperty(value = "保安服务许可/保安培训备案证号（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String servicePermitNumber;

    @ApiModelProperty(value = "发证机关名称（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String nameOfIssuingAuthority;

    @ApiModelProperty(value = "保安服务许可证首次发证日期或者培训单位的发证日期（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private Date firstIssueServicePermit;

    @ApiModelProperty(value = "保安服务许可证扫描件或者保安培训许可（备案）证扫描件（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String servicePermitAttachment;


    @ApiModelProperty(value = "批准文号（机构类型 = 保安服务公司 必填）")
    private String securityApprovalNumber;

    @ApiModelProperty(value = "服务范围（机构类型 = 保安服务公司 必填）")
    private List<String> serviceScopeList;

    @ApiModelProperty(value = "人力防范评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecurityPreparednessRating")
    private SecurityPreparednessRating securityPreparednessRating;

    @ApiModelProperty(value = "武装守护押运评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecurityArmedRating")
    private SecurityArmedRating securityArmedRating;

    @ApiModelProperty(value = "安全技术防范评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating")
    private SecuritySafetyDefenseRating securitySafetyDefenseRating;

    @ApiModelProperty(value = "是否有风险评估资质（机构类型 = 保安服务公司 必填）")
    private Boolean isRiskAssessment;


    @ApiModelProperty(value = "培训单位的培训内容（机构类型 = 保安培训单位 必填）")
    private String trainContent;


    //自行招用保安员单位
    @ApiModelProperty(value = "拟自招保安员数（机构类型 = 自行招用保安员单位 必填）")
    private Integer numberOfSecurityGuards;

    @ApiModelProperty(value = "是否治安保卫重点单位（机构类型 = 自行招用保安员单位 必填）")
    private Boolean isPublicSecuritySecurity;

    @ApiModelProperty(value = "是否物业企业（机构类型 = 自行招用保安员单位 必填）")
    private Boolean isPropertyEnterprise;

    @ApiModelProperty(value = "自招保安单位性质（机构类型 = 自行招用保安员单位 必填）")
    private String natureOfSelfRecruitedUnits;


    //监管归属
    @ApiModelProperty(value = "监管地区")
    private LocationRequest placeOfSupervise;

    @ApiModelProperty(value = "监管机构")
    private String superviseDepartId;

    @ApiModelProperty(value = "监管机构名称")
    private String superviseDepartName;


    @ApiModelProperty(value = "系统管理员", required = true)
    @NotNull(message = "系统管理员不能为空")
    private ContactRequest administrator;


    @ApiModelProperty(value = "动态扩展配置")
    private Map<String,String> dynamic;

    @ApiModelProperty(value = "动态扩展字段（可自定义表单json）")
    private Map<String, Object> dynamicFields;

    @ApiModel("企业人员信息")
    @Data
    public static class ContactRequest implements Serializable {
        @ApiModelProperty(value = "姓名", required = true)
        @NotBlank(message = "姓名不能为空")
        private String name;

        @ApiModelProperty(value = "手机号码", required = true)
        @NotBlank(message = "手机号码不能为空")
        private String telephone;

        @ApiModelProperty(value = "证件类型", notes = "com.bcxin.Infrastructures.enums.CredentialType", required = true)
        @NotNull(message = "证件类型不能为空")
        private CredentialType credentialType;

        @ApiModelProperty(value = "证件号码", required = true)
        @NotBlank(message = "证件号码不能为空")
        private String credentialNumber;

        @ApiModelProperty(value = "国籍")
        private String nationality;
    }

    public LocationRequest getPlaceOfSupervise() {
        if (this.placeOfSupervise != null
                && (this.placeOfSupervise.getDistrict() == null || StringUtils.isBlank(this.placeOfSupervise.getDistrict().getCode()))) {
            //监管地区不为空  &&  区为空，需要给区赋值，方便后面取值
            LocationRequest.ItemValueRequest district = new LocationRequest.ItemValueRequest();
            if (this.placeOfSupervise.getCity() != null && StringUtils.isNotBlank(this.placeOfSupervise.getCity().getCode())) {
                district.setCode(this.placeOfSupervise.getCity().getCode());
                district.setName(this.placeOfSupervise.getCity().getName());
            } else if (this.placeOfSupervise.getProvince() != null && StringUtils.isNotBlank(this.placeOfSupervise.getProvince().getCode())) {
                district.setCode(this.placeOfSupervise.getProvince().getCode());
                district.setName(this.placeOfSupervise.getProvince().getName());
            }
            this.placeOfSupervise.setDistrict(district);
        }
        return placeOfSupervise;
    }
}
