package com.bcxin.api.interfaces.tenants.requests.employees;

import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class BatchAssignEmployeeSuperiorRequest implements Serializable {
    private final Collection<AssignEmployeeSuperiorItem> items;

    public BatchAssignEmployeeSuperiorRequest(Collection<AssignEmployeeSuperiorItem> items) {
        this.items = items;
    }

    @Getter
    public static class AssignEmployeeSuperiorItem implements Serializable{
        private final String originalSuperiorId;
        private final String newSuperiorId;

        public AssignEmployeeSuperiorItem(String originalSuperiorId, String newSuperiorId) {
            this.originalSuperiorId = originalSuperiorId;
            this.newSuperiorId = newSuperiorId;
        }

        public static AssignEmployeeSuperiorItem create(String originalSuperiorId, String newSuperiorId) {
            return new AssignEmployeeSuperiorItem(originalSuperiorId, newSuperiorId);
        }
    }
}
