package com.bcxin.api.interfaces.tenants.requests;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
public class TocWechatCgiConfirmCheckStatusRequest extends RequestAbstract {
    @ApiModelProperty(value = "tenantUserId")

    private final String tenantUserId;
    @ApiModelProperty(value = "姓名")
    private final String name;

    @ApiModelProperty(value = "证件类型")
    private final CredentialType credentialType;

    @ApiModelProperty(value = "证件号")
    private final String number;

    @ApiModelProperty(value = "人头像")
    private final String headPhoto;

    @ApiModelProperty(value = "身份证人像面")
    private final String frontPhoto;

    @ApiModelProperty(value = "身份证国徽面")
    private final String reversePhoto;

    @ApiModelProperty(value = "身份证地址")
    private final String address;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateFrom;

    @ApiModelProperty(value = "有效期到")
    private final Date validDateTo;

    @ApiModelProperty(value = "手机信息")
    private final String phone;

    @ApiModelProperty(value = "活体头像")
    private final String certificateImage;

    private final String ipAddress;


    public TocWechatCgiConfirmCheckStatusRequest(String tenantUserId,
                                                 String name,
                                                 CredentialType credentialType,
                                                 String number,
                                                 String headPhoto, String frontPhoto,
                                                 String reversePhoto, String address,
                                                 Date validDateFrom,
                                                 Date validDateTo,
                                                 String certificateImage,
                                                 String phone,
                                                 String ipAddress) {
        this.tenantUserId = tenantUserId;
        this.credentialType = credentialType;
        this.name = name;
        this.number = number;
        this.headPhoto = headPhoto;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.certificateImage = certificateImage;
        this.phone = phone;
        this.ipAddress = ipAddress;
    }

    public static TocWechatCgiConfirmCheckStatusRequest create(
            String tenantUserId,
            String name,
            CredentialType credentialType,
            String number,
                                                               String headPhoto, String frontPhoto,
                                                               String reversePhoto, String address,
                                                               Date validDateFrom,
                                                               Date validDateTo,
            String certificateImage,
            String phone,
            String ipAddress) {
        return new TocWechatCgiConfirmCheckStatusRequest(
                tenantUserId,name,credentialType,number,headPhoto,frontPhoto,reversePhoto,address,validDateFrom,validDateTo,
                certificateImage,phone,ipAddress);
    }
}
