package com.bcxin.api.interfaces.tenants.criterias;

import com.bcxin.api.interfaces.CriteriaAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class DepartAdminCriteria extends CriteriaAbstract {
    private final String organizationId;
    private final String employeeId;

    private final Collection<String> departIds;
    private final Collection<String> adminDepartIds;

    private final String keyword;

    public DepartAdminCriteria(int pageIndex,int pageSize, String organizationId, String employeeId,Collection<String> departIds,Collection<String> adminDepartIds,String keyword) {
        this.organizationId = organizationId;
        this.employeeId = employeeId;
        this.departIds = departIds;
        this.adminDepartIds = adminDepartIds;
        this.keyword = keyword;
        this.changePage(pageIndex, pageSize);
    }

    public static DepartAdminCriteria create(int pageIndex,int pageSize,String organizationId, String employeeId,Collection<String> departIds,Collection<String> adminDepartIds,String keyword) {
        return new DepartAdminCriteria(pageIndex, pageSize, organizationId, employeeId,departIds,adminDepartIds,keyword);
    }
}
