package com.bcxin.api.interfaces.rbacs.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class AssignUserRequest extends RequestAbstract {
    private final Collection<UserItem> items;

    public AssignUserRequest(Collection<UserItem> items) {
        this.items = items;
    }

    public static AssignUserRequest create(Collection<UserItem> items) {
        return new AssignUserRequest(items);
    }

    @Getter
    public static class UserItem  {
        private final String referencedId;
        private final String name;
        private final Collection<String> roleIds;

        public UserItem(String referencedId, String name, Collection<String> roleIds) {
            this.referencedId = referencedId;
            this.name = name;
            this.roleIds = roleIds;
        }
    }
}
