package com.bcxin.api.interfaces.commons.responses;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class RegionTreeResponse implements Serializable {

    /**
     * 区域ID
     */
    private String value;

    /**
     * 区域名称
     */
    private String label;

    /**
     * 上级id
     */
    private String parentId;

    /**
     * 下级
     */
    private List<RegionTreeResponse> children;

    public RegionTreeResponse(){}
    public RegionTreeResponse(String value,String label,String parentId){
        this.value = value;
        this.label = label;
        this.parentId = parentId;
    }
    public static RegionTreeResponse create(String value,String label,String parentId){
        return new RegionTreeResponse(value,label,parentId);
    }
}
