package com.bcxin.api.interfaces;

import com.bcxin.api.interfaces.enums.LoginFromType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public abstract class RequestAbstract implements Serializable {
    //主版本
    @ApiModelProperty(value = "版本号;仅APP端使用(小程序可以忽略)", required = false)
     String version;
    //热更新版本
    @ApiModelProperty(value = "版本号;仅APP端使用(小程序可以忽略)", required = false)
     String wgtVersion;

    //登录类型
    @ApiModelProperty(value = "登入的系统: BBD=百保盾; BKT=百课堂; WECHAT_CGI=赛演APP", required = false)
    LoginFromType loginFrom;

    @ApiModelProperty(value = "传入当前所在组织的区域编码; 参考先有百保盾APP调用的方式", required = false)
    String areaCode;
}
