package com.bcxin.api.interfaces;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter
public abstract class CriteriaAbstract implements Serializable {
    private int pageIndex;
    private int pageSize;
    private boolean ignorePermission;

    public int getPageIndex() {
        if (this.pageIndex <= 0) {
            return 0;
        }

        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize <= 0 ? 20 : this.pageSize;
    }

    public void changePage(int pageIndex,int pageSize) {
        this.setPageIndex(pageIndex);
        this.setPageSize(pageSize);
    }

    public void markIgnorePermission(boolean ignorePermission) {
        this.ignorePermission = ignorePermission;
    }
}
