/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.utils.StringUtils;

public class AuthUtil {
    public static boolean isBeiJingCompany() {
        return AuthUtil.getAreaCode().startsWith("11");
    }

    public static boolean isBeijingCompany(String areaCode) {
        return !StringUtils.isEmpty(areaCode) && areaCode.startsWith("11");
    }

    public static boolean isHunanCompany(String areaCode) {
        return !StringUtils.isEmpty(areaCode) && areaCode.startsWith("43");
    }

    public static boolean isNingxiaCompany(String areaCode) {
        return !StringUtils.isEmpty(areaCode) && areaCode.startsWith("64");
    }

    public static boolean isShanxiCompany(String areaCode) {
        return !StringUtils.isEmpty(areaCode) && areaCode.startsWith("61");
    }

    public static boolean isUnDistinguishArea() {
        return AuthUtil.getAreaCode().startsWith("43") || AuthUtil.getAreaCode().startsWith("64");
    }

    public static boolean isUnDistinguishArea(String areaCode) {
        return areaCode.startsWith("43") || areaCode.startsWith("64");
    }

    public static String getAreaCode() {
        try {
            if (TenantContext.getInstance() != null && TenantContext.getInstance().getUserContext() != null) {
                return TenantContext.getInstance().getUserContext().getAreaCode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getShortAreaCode() {
        String areaCode = AuthUtil.getAreaCode();
        if (StrUtil.isNotEmpty((CharSequence)areaCode) && areaCode.length() >= 2) {
            return areaCode.substring(0, 2);
        }
        return "";
    }

    public static String getShortAreaCode(String areaCode) {
        if (StrUtil.isNotEmpty((CharSequence)areaCode) && areaCode.length() >= 2) {
            return areaCode.substring(0, 2);
        }
        return "";
    }

    public static OperatorValueType getCurrentOperator() {
        if (TenantContext.getInstance() == null || TenantContext.getInstance().getUserContext() == null || TenantContext.getInstance().getUserContext().get() == null) {
            return OperatorValueType.create(null, null);
        }
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        return OperatorValueType.create(currentUser.getId(), currentUser.getName());
    }

    public static boolean isAdmin() {
        if (TenantContext.getInstance() == null || TenantContext.getInstance().getUserContext() == null || TenantContext.getInstance().getUserContext().get() == null) {
            return false;
        }
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        return currentUser.isMaster();
    }
}

