/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.entities;

import com.bcxin.Infrastructures.entities.ValueType;
import com.bcxin.Infrastructures.utils.DateUtil;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class OperatorValueType
extends ValueType {
    private String id;
    private String name;
    private Timestamp createdTime = Timestamp.from(Instant.now());
    @Transient
    private String operatorTime;

    protected OperatorValueType() {
    }

    public static OperatorValueType create(String id, String name) {
        OperatorValueType operator = new OperatorValueType();
        operator.setId(id);
        operator.setName(name);
        return operator;
    }

    public String getOperatorTime() {
        if (this.createdTime != null) {
            return DateUtil.format2ShortDate(this.createdTime, "yyyy-MM-dd HH:mm:ss");
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setOperatorTime(String operatorTime) {
        this.operatorTime = operatorTime;
    }
}

