package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.identity.domains.enums.ForgetPasswordAction;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class PrepareResetPasswordCommand extends CommandAbstract {
    private final String loginName;
    private final String data;
    private final ForgetPasswordAction action;

    private PrepareResetPasswordCommand(String loginName, String data, ForgetPasswordAction action) {
        this.loginName = loginName;
        this.data = data;
        this.action = action;
    }

    public static PrepareResetPasswordCommand create(String loginName, String data, ForgetPasswordAction action) {
        return new PrepareResetPasswordCommand(loginName, data, action);
    }

    @Override
    public void validate() {
        if(this.getAction()==null) {
            throw new BadTenantException("Action不能为空");
        }

        if(!StringUtils.hasLength(this.getLoginName()) ) {
            throw new BadTenantException("账号不能为空");
        }
    }
}
