package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class ChangePasswordCommand extends CommandAbstract {
    private final String identityUserId;
    private final String userName;
    private final String password;
    private final String newPassword;
    private final String confirmedPassword;

    private ChangePasswordCommand(
            String identityUserId,
            String userName, String password,
                                 String newPassword, String confirmedPassword) {
        this.identityUserId = identityUserId;
        this.userName = userName;
        this.password = password;
        this.newPassword = newPassword;
        this.confirmedPassword = confirmedPassword;
    }

    public static ChangePasswordCommand create(
            String identityUserId,
            String userName, String password,
                                               String newPassword, String confirmedPassword) {
        return new ChangePasswordCommand(identityUserId, userName, password, confirmedPassword, newPassword);
    }

    @Getter
    public static class ChangePasswordCommandResult {
        private final boolean success;

        private ChangePasswordCommandResult(boolean success) {
            this.success = success;
        }

        public static ChangePasswordCommandResult create(boolean success) {
            return new ChangePasswordCommandResult(success);
        }
    }
}
