package com.bcxin.identity.domains.components;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.api.interfaces.identities.requests.SmsRequest;
import com.bcxin.identity.domains.services.commandResult.SMSCommandResult;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class SmsExecutor{

    private final RedisUtil redisUtil;

    private final MessageRpcProvider messageRpcProvider;

    public SmsExecutor(RedisUtil redisUtil,MessageRpcProvider messageRpcProvider) {
        this.redisUtil = redisUtil;
        this.messageRpcProvider = messageRpcProvider;
    }

    /**
     * 发送验证码
     * @param request
     * @return
     */
    public SMSCommandResult sendCode(SmsRequest request) {
        String key = request.getBusinessType().name() +":"+request.getPhone();
        String countKey = request.getBusinessType().name() +":count:"+DateUtil.today()+":"+request.getPhone();
        int count =0;
        if(redisUtil.get(countKey)!= null){
            count = (int)redisUtil.get(countKey);
            if(count >= 2){
                throw new NotSupportTenantException("超过今天发送次数！");
            }
            count ++;
        }
        redisUtil.set(countKey,count,24*60*60);

        if(redisUtil.get(key) == null){
            Map<String, Object> huaWeiSmsContent = new HashMap<>();
            huaWeiSmsContent.put("smsCode", "B02");
            String code = verificationCode();
            List<String> sendParams = new ArrayList();
            sendParams.add(code);
            huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
            huaWeiSmsContent.put("mobile", request.getPhone());
            this.messageRpcProvider.dispatch(MessageRequest.create(MessageType.SMS, huaWeiSmsContent));
            redisUtil.set(key,code,180);
            System.out.println(code);
        }

        return SMSCommandResult.create(true, "200");
    }

    //生成随验证码
    public static String verificationCode() {

        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; i++) {
            result += random.nextInt(10);
        }
        return result;
    }

    public boolean checkCode(SmsRequest request) {
        String key = request.getBusinessType().name() +":"+request.getPhone();
        if(redisUtil.get(key) != null){
            if(request.getCode().equals(redisUtil.get(key).toString())){
                return true;
            }
        }

        return false;
    }
}
