/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.entities;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.api.interfaces.enums.UpdatePasswordType;
import com.bcxin.identity.domains.components.PasswordEncoder;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.entities.PrincipalAbstract;
import com.bcxin.identity.domains.enums.AlgorithmType;
import com.bcxin.identity.domains.enums.EventAction;
import com.bcxin.identity.domains.enums.PrincipalStatus;
import com.bcxin.identity.domains.events.IdentityUserDomainEvent;
import com.bcxin.identity.domains.exceptions.IdentityNotMatchedException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.springframework.util.StringUtils;

@Entity
@Table(name="identity_userpassword", uniqueConstraints={@UniqueConstraint(name="identity_username_password_username", columnNames={"user_name"})})
public class UserNamePasswordPrincipalEntity
extends PrincipalAbstract
implements IAggregate {
    @Column(name="user_name", nullable=false, length=50)
    private String userName;
    @Column(name="password", nullable=false, length=200)
    private String password;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=false, name="algorithm_type")
    private AlgorithmType algorithmType;
    @Column(name="update_password_time")
    private Date updatePasswordTime;
    @Column(name="login_fail_count")
    private Integer loginFailCount;
    @Column(name="login_fail_time")
    private Date loginFailTime;

    protected UserNamePasswordPrincipalEntity() {
    }

    public static UserNamePasswordPrincipalEntity create(IdentityUserEntity identityUser, String id, String userName, AlgorithmType algorithmType, String password) {
        UserNamePasswordPrincipalEntity account = new UserNamePasswordPrincipalEntity();
        account.setIdentityUser(identityUser);
        account.setUserName(userName);
        account.setPassword(password);
        account.setId(id);
        account.setAlgorithmType(algorithmType);
        account.setStatus(PrincipalStatus.ACTIVATE);
        return account;
    }

    public void changePassword(PasswordEncoder passwordEncoder, String oldPassword, String newPassword, String confirmPassword) {
        if (!passwordEncoder.isMatched(this.getPassword(), oldPassword)) {
            throw new IdentityNotMatchedException();
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)newPassword, (CharSequence)confirmPassword)) {
            throw new BadTenantException("\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4!");
        }
        this.setAlgorithmType(AlgorithmType.SM2);
        this.setPassword(passwordEncoder.encode(this.getAlgorithmType(), newPassword));
        this.loginFailClearCount();
        this.setUpdatePasswordTime(new Date());
        this.recordEvent(IdentityUserDomainEvent.create(EventAction.CHANGED_PWD, "\u66f4\u6539\u5bc6\u7801", this.getIdentityUser(), this));
    }

    public void changeUserName(String userName) {
        if (!StringUtils.hasLength((String)userName)) {
            throw new ArgumentTenantException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setUserName(userName);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void resetPassword(PasswordEncoder passwordEncoder, String newPassword, String confirmPassword, boolean isAdminReset) {
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)newPassword, (CharSequence)confirmPassword)) {
            throw new BadTenantException("\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4!");
        }
        this.setAlgorithmType(AlgorithmType.SM2);
        this.setPassword(passwordEncoder.encode(this.getAlgorithmType(), newPassword));
        this.loginFailClearCount();
        if (isAdminReset) {
            this.setUpdatePasswordTime(null);
        } else {
            this.setUpdatePasswordTime(new Date());
        }
        this.recordEvent(IdentityUserDomainEvent.create(EventAction.CHANGED_PWD, "\u66f4\u6539\u5bc6\u7801", this.getIdentityUser(), this));
    }

    public int loginFailAddCount() {
        Date now = new Date();
        int count = 0;
        if (this.getLoginFailCount() != null && this.getLoginFailTime() != null && DateUtil.between((Date)this.getLoginFailTime(), (Date)now, (DateUnit)DateUnit.MINUTE) < 5L) {
            count = this.getLoginFailCount();
        }
        this.setLoginFailCount(++count);
        this.setLoginFailTime(now);
        return count;
    }

    public void loginFailClearCount() {
        this.setLoginFailCount(0);
    }

    public boolean isLock() {
        return this.getLoginFailCount() != null && this.getLoginFailCount() >= 5 && this.getLoginFailTime() != null && DateUtil.between((Date)this.getLoginFailTime(), (Date)new Date(), (DateUnit)DateUnit.MINUTE) < 30L;
    }

    public long getLockRemainingTime() {
        if (this.isLock()) {
            return 30L - DateUtil.between((Date)this.getLoginFailTime(), (Date)new Date(), (DateUnit)DateUnit.MINUTE);
        }
        return 0L;
    }

    public UpdatePasswordType getUpdatePasswordType() {
        if (this.getUpdatePasswordTime() == null) {
            return UpdatePasswordType.NO_UPDATE;
        }
        if (DateUtil.between((Date)this.getUpdatePasswordTime(), (Date)new Date(), (DateUnit)DateUnit.DAY) >= 90L) {
            return UpdatePasswordType.EXCEED_TIME;
        }
        return UpdatePasswordType.NO_TIPS;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public AlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public Date getUpdatePasswordTime() {
        return this.updatePasswordTime;
    }

    public Integer getLoginFailCount() {
        return this.loginFailCount;
    }

    public Date getLoginFailTime() {
        return this.loginFailTime;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected void setAlgorithmType(AlgorithmType algorithmType) {
        this.algorithmType = algorithmType;
    }

    protected void setUpdatePasswordTime(Date updatePasswordTime) {
        this.updatePasswordTime = updatePasswordTime;
    }

    protected void setLoginFailCount(Integer loginFailCount) {
        this.loginFailCount = loginFailCount;
    }

    protected void setLoginFailTime(Date loginFailTime) {
        this.loginFailTime = loginFailTime;
    }
}

