/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

public interface JsonProvider {
    public <T> String getJson(T var1);

    public <T> T toObject(Class<T> var1, String var2);

    public <T> Collection<T> toObjects(Class<T> var1, String var2);

    @Component
    public static class DefaultJsonProvider
    implements JsonProvider {
        @Override
        public <T> String getJson(T data) {
            if (data == null) {
                return null;
            }
            return JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }

        @Override
        public <T> T toObject(Class<T> tClass, String json) {
            try {
                if (!StringUtils.hasLength((String)json)) {
                    return null;
                }
                return (T)JSON.parseObject((String)json, tClass);
            }
            catch (Exception ex) {
                throw new BadTenantException(String.format("\u6570\u636e\u5f02\u5e38:%s \u9884\u671f\u7c7b:%s", json, tClass));
            }
        }

        @Override
        public <T> Collection<T> toObjects(Class<T> tClass, String json) {
            return JSON.parseArray((String)json, tClass);
        }
    }
}

