package com.bcxin.ferry.strategy.receive.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.emus.FileTypeEnum;
import com.bcxin.ferry.common.emus.SendBoundaryUrlEnum;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.service.FerryReceiveTaskFileService;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.strategy.receive.ReceiveStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：接收明细文件策略
 * author：linchunpeng
 * date：2024/3/6
 */
@Slf4j
@Service
public class ReceiveDetailFileStrategy implements ReceiveStrategy {

    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Autowired
    private FerryReceiveTaskFileService ferryReceiveTaskFileService;

    @Async
    @Override
    public void handle(String data) {
        FerryFileDto ferryFileDto = JSONObject.parseObject(data, FerryFileDto.class);
        log.info("接收明细文件策略，基本参数");
        log.info("ferryTaskId：{}", ferryFileDto.getFerryTaskId());
        log.info("requestId：{}", ferryFileDto.getRequestId());
        log.info("fileId：{}", ferryFileDto.getFileId());
        log.info("fileType：{}", ferryFileDto.getFileType());
        //修改接收任务状态-接收明细文件开始
        ferryReceiveTaskService.updateTaskStatusReceiveDetailFileBegin(Long.parseLong(ferryFileDto.getFerryTaskId()));
        //接收文件
        if (ferryFileDto.getFileType() != FileTypeEnum.NORMAL.getCode()) {
            //文件类型不是普通文件
            log.info("文件类型不是普通文件，需要转文件的base64字符串，文件id：{}", ferryFileDto.getFileId());
            ferryFileDto.putFileContent(data);
        }
        ferryReceiveTaskFileService.receiveTaskFile(Long.parseLong(ferryFileDto.getFileId()), ferryFileDto.getImg_base64());
        //回调
        ferryReceiveTaskFileService.callbackToBoundary(Long.parseLong(ferryFileDto.getFileId()), SendBoundaryUrlEnum.SEND_DETAIL_FILE_CALLBACK);
        //修改接收任务状态-接收明细文件完成
        ferryReceiveTaskService.updateTaskStatusReceiveDetailFileComplete(Long.parseLong(ferryFileDto.getFerryTaskId()));
    }
}
