package com.bcxin.ferry.strategy.receive;

import com.bcxin.ferry.common.CommonConstant;
import com.bcxin.ferry.common.utils.SpringContextUtils;

/**
 * 接收策略工厂
 */
public class ReceiveStrategyFactory {

    /**
     * 根据key，获取策略接口实现类
     */
    public static ReceiveStrategy getInstance(String key) {
        switch (key) {
            case CommonConstant.RECEIVE_STRATEGY_KEY_TASK_FILE:
                //接收任务信息文件
                return SpringContextUtils.getBean("receiveTaskFileStrategy", ReceiveStrategy.class);
            case CommonConstant.RECEIVE_STRATEGY_KEY_DETAIL_FILE:
                //接收明细文件
                return SpringContextUtils.getBean("receiveDetailFileStrategy", ReceiveStrategy.class);
        }
        throw new RuntimeException(String.format("接收策略工厂：获取策略异常，key：%s", key));
    }

}
