package com.bcxin.ferry.scheduling;

import cn.hutool.core.util.ZipUtil;
import com.bcxin.ferry.common.utils.ObsUtil;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryReceiveTaskService;
import com.bcxin.ferry.service.FerryTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 * description：查询接收任务状态-接收明细文件完成
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class QueryReceiveDetailFileComplete {

    @Autowired
    private FerryReceiveTaskService ferryReceiveTaskService;
    @Value("${spring.profiles.active}")
    private String activeFile;

    @Scheduled(cron = "${scheduling-config.query-receive-detail-file-complete.cron}")
    public void queryReceiveDetailFileComplete() {
        log.info("===================================定时查询接收任务状态-接收明细文件完成===================================");
        //查询是否有接收明细文件完成的任务
        FerryReceiveTaskEntity receiveTaskEntity = ferryReceiveTaskService.queryReceiveDetailFileComplete();
        if (receiveTaskEntity != null) {
            //合并文件
            ferryReceiveTaskService.mergeFile(receiveTaskEntity);
            //修改任务状态
            ferryReceiveTaskService.updateTaskStatusMergeFileComplete(receiveTaskEntity.getId());
            //压缩文件，并上传OBS
            if (zipAndUpload(receiveTaskEntity.getPackageUrl())) {
                //调用摆渡工具接口，推送数据
                ferryReceiveTaskService.pushData(receiveTaskEntity.getId());
            }
        }
        log.info("===================================查询接收任务状态-接收明细文件完成结束===================================");
    }

    /**
     * description：压缩文件，并上传OBS
     * author：linchunpeng
     * date：2024/4/19
     */
    private boolean zipAndUpload(String filePath) {
        //压缩文件夹
        if ("out-prod".equals(activeFile)) {
            File zip = ZipUtil.zip(filePath);
            //上传OBS
            int uploadCount = 0 ;
            boolean uploadResult = false;
            while (!uploadResult && uploadCount < 10) {
                //预防上传失败
                uploadResult = ObsUtil.uploadFile(zip, filePath.substring(filePath.indexOf("baidu/")).concat(".zip"));
                uploadCount++;
                log.info("第{}次上传OBS，上传：{}", uploadCount, uploadResult);
                if (!uploadResult) {
                    //上传失败，等待2分钟
                    log.info("上传失败，等待2分钟");
                    try {
                        Thread.sleep(120000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            return uploadResult;
        }
        return true;
    }

}
