package com.bcxin.ferry.scheduling;

import com.bcxin.ferry.service.FerryTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：创建摆渡任务
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class CreateFerryTask {

    @Autowired
    private FerryTaskService ferryTaskService;

    @Scheduled(cron = "${scheduling-config.create-ferry-task.cron}")
    public void createFerryTask() {
        log.info("===================================定时创建摆渡任务===================================");
        ferryTaskService.createFerryTask();
        log.info("===================================创建摆渡任务结束===================================");
    }

}
