package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

 /**
 * 接收操作日志表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_receive_operate_log")
public class FerryReceiveOperateLogEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id
    @TableId(value = "id")
    private Long id;
    
    //接收任务id
    private Long taskId;
    
    //操作类型，1-创建任务，2-解析任务文件，3-开始初始化任务信息，4-初始化任务信息完成，5-回调请求端，6-接收明细文件开始，7-接收明细文件完成，8-合并文件开始，9-合并文件完成，10-执行推送操作，11-摆渡完成
    private Integer operateType;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}