package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

 /**
 * 摆渡操作日志表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_operate_log")
public class FerryOperateLogEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id
    @TableId(value = "id")
    private Long id;
    
    //摆渡任务id
    private Long taskId;
    
    //操作类型，1-创建任务，2-请求摆渡工具服务拉取数据接口，3-摆渡工具服务拉取数据完成，4-开始扫描摆渡文件，5-扫描摆渡文件完成，6-生成任务文件，7-请求边界服务接口，摆渡任务文件，8-任务文件摆渡成功，9-开始摆渡明细文件，10-摆渡明细文件完成
    private Integer operateType;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}