package com.bcxin.ferry.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.CommonConstant;
import com.bcxin.ferry.dtos.FerryDto;
import com.bcxin.ferry.dtos.response.boundary.BoundaryCallbackResult;
import com.bcxin.ferry.dtos.FerryFileCallbackDto;
import com.bcxin.ferry.strategy.callback.ReceiveCallbackStrategyFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * description：接口回调接收
 * author：linchunpeng
 * date：2024/3/13
 */
@Slf4j
@RestController
@RequestMapping("/api/receive/callback")
public class ApiReceiveCallbackController {


    /**
     * description：接收任务文件回调
     * author：linchunpeng
     * date：2024/3/13
     */
    @PostMapping("/ferry/task/file")
    public BoundaryCallbackResult ferryTaskFileCallback(@RequestBody FerryFileCallbackDto receiveCallbackDto) {
        String data = JSONObject.toJSONString(receiveCallbackDto);
        log.info("接收任务文件回调，参数：{}", data);
        ReceiveCallbackStrategyFactory.getInstance(CommonConstant.RECEIVE_CALLBACK_STRATEGY_KEY_TASK_FILE).handle(data);
        return new BoundaryCallbackResult("0", "接收成功");
    }

    /**
     * description：接收 明细文件回调
     * author：linchunpeng
     * date：2024/3/13
     */
    @PostMapping("/ferry/detail/file")
    public BoundaryCallbackResult ferryDetailFileCallback(@RequestBody FerryFileCallbackDto receiveCallbackDto) {
        String data = JSONObject.toJSONString(receiveCallbackDto);
        log.info("接收任务文件回调，参数：{}", data);
        ReceiveCallbackStrategyFactory.getInstance(CommonConstant.RECEIVE_CALLBACK_STRATEGY_KEY_DETAIL_FILE).handle(data);
        return new BoundaryCallbackResult("0", "接收成功");
    }

    /**
     * description：接收 发送摆渡完成回调
     * author：linchunpeng
     * date：2024/3/13
     */
    @PostMapping("/ferry/complete")
    public BoundaryCallbackResult ferryComplete(@RequestBody FerryDto receiveCallbackDto) {
        String data = JSONObject.toJSONString(receiveCallbackDto);
        log.info("接收任务文件回调，参数：{}", data);
        ReceiveCallbackStrategyFactory.getInstance(CommonConstant.RECEIVE_CALLBACK_STRATEGY_KEY_FERRY_COMPLETE).handle(data);
        return new BoundaryCallbackResult("0", "接收成功");
    }

}
