package com.bcxin.ferry.common.utils;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.ObsObject;
import lombok.extern.slf4j.Slf4j;

import java.io.*;

@Slf4j
public class ObsUtil {

    private final static String ak = "XPD7LFX49QFQ5CVQSIQH";
    private final static String sk = "DPt2m9mkFVgU4XbFdy0Pb00M4nyJQP1z5pLMubun";
    private final static String endPoint = "https://obs.cn-north-1.myhuaweicloud.com";
    private final static String bucketName = "02obs-file-system-obpm-uploads";

    /**
     * description：下载OBS文件
     * author：linchunpeng
     * date：2024/4/19
     */
    public static boolean downloadFile(String fileSavePath, String objectKey) {
        ///baidu/pull/hunan/20230530011046159.zip
        log.info("下载OBS文件，文件：{}", objectKey);
        // 创建ObsClient实例
        // 使用永久AK/SK初始化客户端
        ObsClient obsClient = new ObsClient(ak, sk, endPoint);
        FileOutputStream fos = null;
        ByteArrayOutputStream bos = null;
        InputStream input = null;
        try {
            // 流式下载
            ObsObject obsObject = obsClient.getObject(bucketName, objectKey);
            // 读取对象内容
            input = obsObject.getObjectContent();
            byte[] b = new byte[1024];
            bos = new ByteArrayOutputStream();
            int len;
            while ((len = input.read(b)) != -1) {
                bos.write(b, 0, len);
            }

            //开始写入
            File file = new File(fileSavePath);
            fos = new FileOutputStream(file);
            fos.write(bos.toByteArray());
            log.info("文件: {}，下载成功", objectKey);
            return true;
        } catch (ObsException e) {
            log.error("文件: {}，下载失败", objectKey);
            // 请求失败,打印http状态码
            log.error("HTTP Code:" + e.getResponseCode());
            // 请求失败,打印服务端错误码
            log.error("Error Code:" + e.getErrorCode());
            // 请求失败,打印详细错误信息
            log.error("Error Message:" + e.getErrorMessage());
            // 请求失败,打印请求id
            log.error("Request ID:" + e.getErrorRequestId());
            log.error("Host ID:" + e.getErrorHostId());
            e.printStackTrace();
            return false;
        } catch (Exception e) {
            log.error("文件: {}，下载失败", objectKey);
            // 其他异常信息打印
            e.printStackTrace();
            return false;
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    /**
     * description：上传OBS文件
     * author：linchunpeng
     * date：2024/4/19
     */
    public static boolean uploadFile(File file, String objectKey) {
        log.info("上传OBS文件");
        // 创建ObsClient实例
        // 使用永久AK/SK初始化客户端
        ObsClient obsClient = new ObsClient(ak, sk,endPoint);
        try {
            // 文件上传
            obsClient.putObject(bucketName, objectKey, file);
            log.info("文件: {}，上传成功", objectKey);
            return true;
        } catch (ObsException e) {
            log.error("文件: {}，上传失败, {}", objectKey, e.getMessage(), e);
            // 请求失败,打印http状态码
            log.error("HTTP Code:" + e.getResponseCode());
            // 请求失败,打印服务端错误码
            log.error("Error Code:" + e.getErrorCode());
            // 请求失败,打印详细错误信息
            log.error("Error Message:" + e.getErrorMessage());
            // 请求失败,打印请求id
            log.error("Request ID:" + e.getErrorRequestId());
            log.error("Host ID:" + e.getErrorHostId());
            e.printStackTrace();
            return false;
        } catch (Exception e) {
            log.error("文件: {}，上传失败", objectKey);
            // 其他异常信息打印
            e.printStackTrace();
            return false;
        }
    }

//    public static void main(String[] args) {
//        downloadFile("/Users/linchunpeng/Downloads/20230530011046159.zip", "baidu/pull/hunan/20230530011046159.zip");
//        uploadFile("/Users/linchunpeng/Downloads/test.zip", "baidu/pull/test.zip");
//    }

}
