package com.bcxin.ferry.common.emus;

/**
 * 摆渡任务状态，1-开始拉取，2-拉取完成，3-扫描摆渡文件完成，4-生成任务文件完成，5-摆渡任务文件开始，6-摆渡任务文件完成，7-摆渡明细文件开始，
 * 8-摆渡明细文件结束，9-摆渡任务完成，-1-摆渡失败
 */
public enum FerryTaskStatusEnum {

    //开始拉取
    BEGIN_PULL(1, "开始拉取"),
    //拉取完成
    PULL_COMPLETE(2, "拉取完成"),
    //扫描摆渡文件完成
    SCAN_FILE_COMPLETE(3, "扫描摆渡文件完成"),
    //生成任务文件完成
    CREATE_TASK_FILE_COMPLETE(4, "生成任务文件完成"),
    //摆渡任务文件开始
    FERRY_TASK_FILE_BEGIN(5, "摆渡任务文件开始"),
    //摆渡任务文件完成
    FERRY_TASK_FILE_COMPLETE(6, "摆渡任务文件完成"),
    //摆渡明细文件开始
    FERRY_DETAIL_FILE_BEGIN(7, "摆渡明细文件开始"),
    //摆渡明细文件结束
    FERRY_DETAIL_FILE_COMPLETE(8, "摆渡明细文件结束"),
    //摆渡任务完成
    FERRY_TASK_COMPLETE(9, "摆渡任务完成"),
    //摆渡失败
    FERRY_FAIL(-1, "摆渡失败");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    FerryTaskStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
