package com.bcxin.ferry.common.emus;

/**
 * 摆渡文件状态，1-拉取完成，2-开始摆渡，3-摆渡完成，4-摆渡失败
 */
public enum FerryTaskFileStatusEnum {

    //拉取完成
    PULL_COMPLETE(1, "拉取完成"),
    //开始摆渡
    FERRY_BEGIN(2, "开始摆渡"),
    //摆渡完成
    FERRY_COMPLETE(3, "摆渡完成"),
    //摆渡失败
    FERRY_FAIL(4, "摆渡失败");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    FerryTaskFileStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
