package com.bcxin.ferry.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.dao.mapper.FerryOperateLogMapper;
import com.bcxin.ferry.entity.FerryOperateLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 摆渡操作日志表(ferry_operate_log)服务实现类
 *
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Slf4j
@Service
public class FerryOperateLogService extends ServiceImpl<FerryOperateLogMapper, FerryOperateLogEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：创建日志
     * author：linchunpeng
     * date：2024/3/22
     */
    public void createLog(Long taskId, Integer operateType) {
        FerryOperateLogEntity log = new FerryOperateLogEntity();
        log.setId(snowflake.snowflakeId());
        log.setTaskId(taskId);
        log.setOperateType(operateType);
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        this.save(log);
    }

}