package com.bcxin.ferry.common.emus;

/**
 * 发送请求到边界服务url
 */
public enum SendBoundaryUrlEnum {

    //发送任务文件
    SEND_TASK_FILE(1, "/api/receive/ferry/task/file"),
    //发送明细文件
    SEND_DETAIL_FILE(2, "/api/receive/ferry/detail/file"),
    //发送任务文件-回调
    SEND_TASK_FILE_CALLBACK(3, "/api/receive/callback/ferry/task/file"),
    //发送明细文件-回调
    SEND_DETAIL_FILE_CALLBACK(4, "/api/receive/callback/ferry/detail/file"),
    //发送摆渡完成-回调
    SEND_FERRY_COMPLETE_CALLBACK(5, "/api/receive/callback/ferry/complete"),
    //其他消息
    SEND_OTHER_MESSAGE(99, "/api/other/message");

    /**
     * 代码
     */
    private int code;
    /**
     * 值
     */
    private String value;

    SendBoundaryUrlEnum(int code, String value) {
        this.code = code;
        this.value = value;
    }

    /**
     * 获取代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取值
     */
    public String getValue() {
        return this.value;
    }
}
