package com.bcxin.ferry.common.emus;

/**
 * 接收任务状态，1-接收请求，2-解析任务文件，3-初始化任务信息，4-回调请求端，5-接收明细文件开始，6-接收明细文件完成，7-合并文件开始，
 * 8-合并文件完成，9-执行推送操作，10-摆渡完成
 */
public enum FerryReceiveTaskStatusEnum {

    //接收请求
    RECEIVE_REQUEST(1, "接收请求"),
    //解析任务文件
    PARSE_TASK_FILE(2, "解析任务文件"),
    //初始化任务信息
    INIT_TASK_INFO(3, "初始化任务信息"),
    //任务文件回调请求端
    TASK_FILE_CALLBACK(4, "任务文件回调请求端"),
    //接收明细文件开始
    RECEIVE_DETAIL_FILE_BEGIN(5, "接收明细文件开始"),
    //接收明细文件完成
    RECEIVE_DETAIL_FILE_COMPLETE(6, "接收明细文件完成"),
    //合并文件开始
    MERGE_FILE_BEGIN(7, "合并文件开始"),
    //合并文件完成
    MERGE_FILE_COMPLETE(8, "合并文件完成"),
    //执行推送操作
    PUSH_DATA(9, "执行推送操作"),
    //摆渡完成
    FERRY_COMPLETE(10, "摆渡完成"),
    //回调完成
    CALLBACK_COMPLETE(11, "回调完成");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    FerryReceiveTaskStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
