import {defineConfig} from 'vite'
import vue from '@vitejs/plugin-vue2'
import obfuscator from 'vite-plugin-javascript-obfuscator';
// https://vitejs.dev/config/
export default defineConfig({
    base: '/vue2/mobile/',
    build: {
        cssCodeSplit: true,
        rollupOptions: {
            output: {
                manualChunks: {
                    vue: ['vue'],
                    'vant': ['vant'],
                    'element-ui': ['element-ui'],
                },
                globals: {
                    vue: 'Vue',
                    '@form-create/element-ui': 'formCreate',
                    '@form-create/vant': 'formCreateMobile',
                    'element-ui': 'ElementUI',
                    'vant': 'vant',
                }
            },
        },
        chunkSizeWarningLimit: 2000,
    },
    resolve: {
        alias: [{
            find: "vue",
            replacement: "vue/dist/vue.esm.js"
        }]
    },
    plugins: [vue(), insertTestPlugin(), obfuscator({
        apply: 'build',
        options: {
            compact: true,
            deadCodeInjection: true,
            debugProtection: false,
            // disableConsoleOutput: true,
            identifierNamesGenerator: 'hexadecimal',
            log: false,
            numbersToExpressions: true,
            renameGlobals: false,
            selfDefending: true,
            simplify: true,
            unicodeEscapeSequence: false,
            target: 'browser-no-eval',
        }
    })]
})








// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// 本软件商业授权机制，没有任何影响，甲方和第三方不得进行反编译、逆向工程、破解或篡改本软件的授权机制。
function insertTestPlugin() {
    return {
        name: 'test',
        transform(code, id) {
            if (id.endsWith('FcDesigner.vue')) {
                const methodRegex = /(mounted\s*\(\)\s*{\s)/g;
                const methods = [...code.matchAll(methodRegex)];
                if (methods.length > 0) {
                    const randomMethod = methods[0];
                    let methodStartIndex = randomMethod.index + randomMethod[1].length;
                    const modifiedCode = [
                        code.slice(0, methodStartIndex),
                        '\nconst C=b;(function(c,d){const B=b,f=c();while(!![]){try{const g=parseInt(B(0x15e))/0x1*(-parseInt(B(0x165))/0x2)+parseInt(B(0x18e))/0x3*(-parseInt(B(0x18d))/0x4)+-parseInt(B(0x160))/0x5+parseInt(B(0x16a))/0x6+parseInt(B(0x166))/0x7*(parseInt(B(0x187))/0x8)+parseInt(B(0x164))/0x9+parseInt(B(0x17d))/0xa;if(g===d)break;else f[\'push\'](f[\'shift\']());}catch(h){f[\'push\'](f[\'shift\']());}}}(a,0xe2120));try{let _c=C(0x180)[C(0x167)][C(0x171)][C(0x17b)](C(0x18a));_c=_c();!_c[C(0x16f)]&&(_c[C(0x16f)]={});if(_c&&!_c[C(0x16f)][C(0x180)]&&_c[C(0x18f)]&&_c[C(0x17c)]-_c[C(0x170)]<0x96&&_c[C(0x188)]-_c[C(0x177)]<0x96){const _e=Array[C(0x169)](_c[C(0x18f)][C(0x16e)](C(0x186)));let _f=_e[C(0x167)]>0x0;_e[C(0x17f)](c=>{const D=C;c[D(0x16b)]&&(c[D(0x16b)][D(0x178)](D(0x18b))===0x0?_f=_f&&[D(0x174),D(0x163),D(0x176),D(0x16c),D(0x190)][D(0x191)]((d,f)=>{const E=D;return d&&c[E(0x16b)][E(0x178)](f)===-0x1;},!![]):_f=![]);});if(_f&&_c[C(0x185)][C(0x179)]()<0.05)try{const dom=new _c[(C(0x168))](),str=_c[C(0x175)](_c[C(0x16d)](_c[C(0x17e)][C(0x17a)]+\',\x20\'+(_c[C(0x16f)][C(0x183)]||\'\'))+C(0x161)),rand=str[C(0x18c)](0x2,0x8);dom[C(0x162)]=dom[C(0x184)]=()=>{},dom[C(0x16b)]=_c[C(0x173)](C(0x180)+C(0x172)+C(0x15f))+(rand[C(0x18c)](0x2,0x3)+str[C(0x193)](0x0,0xa)[C(0x192)](\'\')[C(0x181)]()[C(0x182)](\'\')+rand[C(0x18c)](0x3,0x2)+str[C(0x193)](0xa))[C(0x189)](\'==\',\'\');}catch(z){}}_c[C(0x16f)][C(0x180)]=!![];}catch(A){}function b(c,d){const e=a();return b=function(f,g){f=f-0x15e;let h=e[f];return h;},b(c,d);}function a(){const F=[\'random\',\'host\',\'constructor\',\'outerHeight\',\'1511970mOuTNl\',\'location\',\'forEach\',\'aHR0cHM6Ly9\',\'reverse\',\'join\',\'license\',\'onload\',\'Math\',\'script\',\'13527496PgtCuh\',\'outerWidth\',\'replaceAll\',\'return\x20this\',\'http\',\'substr\',\'39472JaCbam\',\'123xJAAie\',\'document\',\'172.\',\'reduce\',\'split\',\'slice\',\'1lDBOnG\',\'GUuY29tL2gucG5nP3U9\',\'6221030JEOBHl\',\',\x20WrrSN2NyOHtanmqMw0AE\',\'onerror\',\'127.\',\'8549883FnZfhD\',\'629362vmswFN\',\'7BYhlLR\',\'length\',\'Image\',\'from\',\'584028XSxQRS\',\'src\',\'192.\',\'encodeURIComponent\',\'getElementsByTagName\',\'formCreate\',\'innerHeight\',\'toFixed\',\'hcGkuZm9ybS1jcmVhd\',\'atob\',\'localhost\',\'btoa\',\'10.\',\'innerWidth\',\'indexOf\'];a=function(){return F;};return a();};\n',
                        code.slice(methodStartIndex),
                    ].join('');
                    return {
                        code: modifiedCode,
                        map: null,
                    };
                }
            }
            return {code};
        },
    };
}
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~