export default function (fc) {
    const easySlots = {
        name: 'easySlots',
        load(attr, rule) {
            const value = attr.getValue();
            const renderSlots = {};
            if (value) {
                Object.keys(value).forEach((key) => {
                    const on = {};
                    Object.keys(value[key].on || {}).forEach(k => {
                        on[k] = fc.$handle.inject(rule, value[key].on[k]);
                    });
                    renderSlots[key] = value[key].type === 'icon' ? {
                        type: 'i',
                        class: 'fc-icon iconfont ' + value[key].value,
                        on,
                        style: value[key].style,
                    } : {
                        type: 'div',
                        on,
                        style: value[key].style,
                        children: ['' + (value[key].value || '')],
                    }
                })
            }
            attr.getProp().renderSlots = renderSlots;
        },
    }
    easySlots.watch = easySlots.load;

    return easySlots;
}
