import {localeOptions, localeProps} from '../../utils';

const label = '表单项';
const name = 'vanField';

export default {
    menu: 'container',
    icon: 'icon-form-item',
    label,
    name,
    drag: true,
    dragBtn: true,
    mask: false,
    event: false,
    slot: ['input'],
    rule({t}) {
        return {
            type: name,
            props: {
                label: t('com.vanField.name'),
            },
            children: []
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {type: 'input', field: 'label'},
            {type: 'SizeInput', field: 'labelWidth'},
            {
                type: 'select',
                field: 'labelAlign',
                title: t('form.labelAlign'),
                options: localeOptions(t, [
                    {
                        label: 'center',
                        value: 'center',
                    },
                    {
                        label: 'left',
                        value: 'left',
                    },
                    {
                        label: 'right',
                        value: 'right',
                    },
                ])
            }, {
                type: 'select',
                field: 'inputAlign',
                title: t('form.inputAlign'),
                options: localeOptions(t, [
                    {
                        label: 'left',
                        value: 'left',
                    },
                    {
                        label: 'center',
                        value: 'center',
                    },
                    {
                        label: 'right',
                        value: 'right',
                    },
                ])
            },
        ]);
    }
};
