import {$del, $set} from '@form-create/utils';

const label = '盒子布局';
const name = 'fcFlex2';


export default {
    menu: 'layout',
    icon: 'icon-flex',
    name,
    label,
    drag: true,
    inside: true,
    inline: true,
    mask: false,
    sfc(rule) {
        rule.type = 'div';
    },
    actions: [
        {
            label: 'com.fcFlex2.horizontal',
            handler(rule) {
                if (!rule.style) {
                    $set(rule, 'style', {});
                }
                if (rule.style.display !== 'flex') {
                    $set(rule.style, 'display', 'flex');
                    $set(rule.style, 'flexDirection', 'row');
                    $set(rule.style, 'justifyContent', 'center');
                } else if (['column-reverse', 'column'].indexOf(rule.style.flexDirection) > -1) {
                    $set(rule.style, 'alignItems', 'center');
                } else {
                    $set(rule.style, 'justifyContent', 'center');
                }
                $set(rule, 'style', {...rule.style});
            }
        },
        {
            label: 'com.fcFlex2.vertical',
            handler(rule) {
                if (!rule.style) {
                    $set(rule, 'style', {});
                }
                if (rule.style.display !== 'flex') {
                    $set(rule.style, 'display', 'flex');
                    $set(rule.style, 'flexDirection', 'row');
                    $set(rule.style, 'alignItems', 'center');
                } else if (['column-reverse', 'column'].indexOf(rule.style.flexDirection) > -1) {
                    $set(rule.style, 'justifyContent', 'center');
                } else {
                    $set(rule.style, 'alignItems', 'center');
                }
                $set(rule, 'style', {...rule.style});
            }
        },
        {
            label: 'com.fcFlex2.left',
            handler(rule) {
                if (!rule.style) {
                    $set(rule, 'style', {});
                }
                if (rule.style.display !== 'flex') {
                    $set(rule.style, 'display', 'flex');
                    $set(rule.style, 'flexDirection', 'row');
                    $set(rule.style, 'justifyContent', 'flex-start');
                } else if (['column-reverse', 'column'].indexOf(rule.style.flexDirection) > -1) {
                    $set(rule.style, 'alignItems', 'flex-start');
                } else {
                    $set(rule.style, 'justifyContent', 'flex-start');
                }
                $set(rule, 'style', {...rule.style});
            }
        },
        {
            label: 'com.fcFlex2.right',
            handler(rule) {
                if (!rule.style) {
                    $set(rule, 'style', {});
                }
                if (rule.style.display !== 'flex') {
                    $set(rule.style, 'display', 'flex');
                    $set(rule.style, 'flexDirection', 'row');
                    $set(rule.style, 'justifyContent', 'flex-end');
                } else if (['column-reverse', 'column'].indexOf(rule.style.flexDirection) > -1) {
                    $set(rule.style, 'alignItems', 'flex-end');
                } else {
                    $set(rule.style, 'justifyContent', 'flex-end');
                }
                $set(rule, 'style', {...rule.style});
            }
        },
        {
            label: 'com.fcFlex2.reset',
            handler(rule) {
                if (!rule.style) {
                    $set(rule, 'style', {});
                } else {
                    $del(rule.style, 'flexDirection');
                    $del(rule.style, 'justifyContent');
                    $del(rule.style, 'alignContent');
                    $del(rule.style, 'flexWrap');
                    $del(rule.style, 'alignItems');
                    $set(rule.style, 'display', 'flex');
                    $set(rule, 'style', {...rule.style});
                }
            }
        },
    ],
    rule() {
        return {
            type: 'fcCell',
            style: {
                display: 'block',
                width: '100%',
            },
            children: [],
        };
    },
    props(_, {t}) {
        return [{
            type: 'SizeInput',
            field: 'formCreateStyle>width',
            title: t('style.width')
        }, {
            type: 'SizeInput',
            field: 'formCreateStyle>height',
            title: t('style.height')
        }]
    }
};
