import {isNull, localeOptions} from '../../utils';

function updateConfigInfo(key, t) {
    return function (val, rule, api) {
        const temp = {...val || {}};
        Object.keys(temp).forEach(k => {
            if (isNull(temp[k])) {
                delete temp[k];
            }
        })
        api.getRule(key).props.info = Object.keys(temp).length > 0 ? t('struct.configured') : '';
    }
}

export default function form({t}) {

    return [
        {
            type: 'input',
            field: 'formCreateFormName',
            value: '',
            title: t('form.formName'),
        }, {
            type: 'select',
            field: 'labelAlign',
            title: t('form.labelAlign'),
            options: localeOptions(t, [
                {
                    label: 'center',
                    value: 'center',
                },
                {
                    label: 'left',
                    value: 'left',
                },
                {
                    label: 'right',
                    value: 'right',
                },
            ])
        }, {
            type: 'radio',
            field: 'inputAlign',
            title: t('form.inputAlign'),
            options: localeOptions(t, [
                {
                    label: 'left',
                    value: 'left',
                },
                {
                    label: 'center',
                    value: 'center',
                },
                {
                    label: 'right',
                    value: 'right',
                },
            ])
        },
        {
            type: 'SizeInput',
            field: 'labelWidth',
            title: t('form.labelWidth'),
        },
        {
            type: 'switch',
            field: 'colon',
            title: t('form.colon'),
        }, {
            type: 'switch',
            field: '_submitBtn>show',
            value: true,
            title: t('form.submitBtn'),
        }, {
            type: 'switch',
            field: '_resetBtn>show',
            value: false,
            title: t('form.resetBtn'),
        },  {
            type: 'switch',
            field: 'formCreateIgnoreHiddenFields',
            value: false,
            title: t('form.ignoreHiddenFields'),
            warning: t('warning.ignoreHiddenFields'),
        }, {
            type: 'ConfigItem',
            col: {show: true},
            name: 'titleStyle',
            style: 'margin-bottom: 10px',
            props: {
                label: t('form.labelStyle'),
                info: '',
            },
            children: [{
                type: 'StyleConfig',
                field: 'title>style',
                wrap: {show: false},
                value: {},
                slot: 'append',
                update: updateConfigInfo('titleStyle', t),
            }]
        },
        {
            type: 'FnConfig',
            field: 'formCreate_event',
            name: 'event',
            value: {},
            col: {show: true},
            props: {
                eventConfig: [
                    {
                        name: 'onSubmit',
                        info: t('form.onSubmit'),
                        args: ['formData', 'api'],
                    },
                    {
                        name: 'onReset',
                        info: t('form.onReset'),
                        args: ['api'],
                    },
                    {
                        name: 'onCreated',
                        info: t('form.onCreated'),
                        args: ['api'],
                    },
                    {
                        name: 'onMounted',
                        info: t('form.onMounted'),
                        args: ['api'],
                    },
                    {
                        name: 'onReload',
                        info: t('form.onReload'),
                        args: ['api'],
                    },
                    {
                        name: 'onChange',
                        info: t('form.onChange'),
                        args: ['field', 'value', 'options'],
                    },
                    {
                        name: 'beforeSubmit',
                        info: t('form.beforeSubmit'),
                        args: ['formData', 'data'],
                    },
                    {
                        name: 'beforeFetch',
                        info: t('form.beforeFetch'),
                        args: ['config', 'data'],
                    },
                ]
            },
            title: t('form.event'),
        },
    ];
}
