/*!
 * FormCreate商业版可视化移动端表单设计器-让表单设计更简单
 * fc-designer-mobile-vue2 v5.7.2
 * (c) 2021-2025 FormCreate Team
 * Github https://github.com/xaboy/form-create-designer
 * license 仅限于被授权主体（个人、企业或组织）使用
 */
const e = {
  name: "en",
  form: {
    field: "Field",
    title: "Title",
    info: "Info",
    ignore: "ignore field",
    native: "Whether to display title",
    control: "Control",
    labelAlign: "Label position",
    inputAlign: "Input position",
    labelStyle: "Label style",
    colon: "Whether to add a colon after the label",
    formItem: "Configure form item",
    globalEvent: "Global event",
    globalFetch: "Global dataset",
    globalClass: "Global style",
    globalConfig: "Global",
    size: "Form size",
    event: "Form event",
    labelWidth: "Label width",
    hideRequiredAsterisk: "Hide the red asterisk next to the label of a required field",
    showMessage: "Display verification error message",
    inlineMessage: "Display validation information inline",
    submitBtn: "Whether to display the form submit button",
    resetBtn: "Whether to display the form reset button",
    appendChild: "Insert child",
    formMode: "Form mode",
    formName: "Form name",
    ignoreHiddenFields: "Ignore hidden fields when submitting form",
    previewMode: "Reading mode",
    componentMode: "Component",
    sfcMode: "SFC",
    document: "Document",
    controlDocument: "Need more detailed configuration methods? Please view {doc}",
    onSubmit: "Triggered when form is submitted",
    onReset: "Triggered after form is reset",
    onCreated: "Triggered after the form component is initialized",
    onMounted: "Triggered after the form component is mounted",
    onReload: "Triggered after the form rendering rule is reloaded",
    onChange: "Triggered when the component value changes",
    beforeSubmit: "Triggered when form validation passed",
    beforeFetch: "Triggered before remote data request is sent"
  },
  ai: {
    name: "Smart Assistant",
    info: "Hello! I'm your smart form assistant. I can help you quickly create and edit forms for efficient design.",
    try: "Try asking me",
    change: "Change",
    loading: "Generating your form, please wait...",
    fail: "There was an issue creating the form. Please adjust your request.",
    success: "Processing complete!",
    placeholder: "Describe your requirements"
  },
  warning: {
    name: "Unique identifier for the component, used to access and modify its configuration rules.",
    field: "Field name for binding data to the component. Must start with a letter for proper recognition.",
    formList: "Manages and switches form templates for quick switching and configuration in different business scenarios.",
    fetch: "Loads remote data through requests, updating the component based on the returned result.",
    fetchQuery: "Defines GET parameters for requests, passed via the URL.",
    fetchData: "Defines POST parameters for requests, passed in the request body.",
    fetchDataType: "Selects the data type for the request body to ensure correct format.",
    beforeFetch: "Before the request is sent, you can modify the parameters via a handler. Return false or a rejected Promise to cancel the request.",
    fetchParse: "Processes the response data after the request and converts it into the required structure.",
    language: "Manages multilingual data, allowing easy language switching for content display.",
    variable: "Reads configuration values from variables (e.g., Cookie, localStorage) and syncs updates when variables change.",
    variableBar: "The variable list contains all form-related variables. Click a variable to quickly insert the code or copy the name.",
    variableInfo: "Select a variable from the list. If the variable is an object, access its properties using the format {{variableName.attributeName}}.",
    pageManage: "Manages sub-dialogs in forms, triggered by events to dynamically display information or enable interaction.",
    globalConfig: "Manages global events, styles, data, and variables for data sharing and event handling across components.",
    globalClass: "Defines global styles and classes for unified style management in component configurations.",
    globalEvent: "Defines global events for components to use, simplifying event management across components.",
    globalFetch: "Defines global data sources for static and remote data, used across component configurations.",
    globalVariable: "Defines computed properties in global variables, automatically updating when associated data changes.",
    ignore: "Excludes the component’s field from submission data when enabled.",
    ignoreHiddenFields: "Excludes hidden fields from form submission when enabled.",
    behaviorIgnoreError: "Defines whether to continue executing subsequent actions if an error occurs.",
    behaviorExpression: "Executes actions only when conditions are met.",
    behaviorStopPropagation: "Stops subsequent actions from executing when conditions are met.",
    computedCondition: "Automatically adjusts component states and data based on defined conditions.",
    computedFormula: "Dynamically calculates component states and data based on formulas and form data."
  },
  computed: {
    value: {
      title: "Data linkage",
      btn: "Set data linkage",
      name: "Set component value"
    },
    hidden: {
      title: "Hide condition",
      btn: "Set condition",
      name: "Set Hide condition for component"
    },
    required: {
      title: "Required condition",
      btn: "Set condition",
      name: "Set required condition for component"
    },
    disabled: {
      title: "Disable condition",
      btn: "Set condition",
      name: "Set disabled condition for component"
    },
    formulas: {
      "==": "Equal",
      "!=": "Not equal",
      on: "Include",
      notOn: "Not included",
      empty: "Is empty",
      notEmpty: "Not empty",
      pattern: "Regular",
      ">": "Greater than",
      ">=": "Greater than or equal",
      "<": "Less than",
      "<=": "Less than or equal"
    },
    variable: {
      attr: "Attribute list",
      bind: "Bind variable",
      list: "Variable list",
      btn: "Set variable",
      title: "Global variable",
      create: "Create variable",
      placeholder: "Please enter a description of the variable"
    },
    linkage: {
      trigger: "Trigger the following linkage",
      info: [
        "The current component linkage display the value of"
      ]
    },
    name: "Calculation formula",
    setting: "Setting conditions",
    invert: "Component status after the condition is met",
    condition: "Logic condition",
    addCondition: "Add condition",
    addGroup: "Add condition group",
    form: "Current",
    subform: "Subform",
    formula: "Formula",
    formulaInfo: "Function description",
    formulaExample: "Function example",
    fieldUsed: "[{label}] Is used in the calculation formula, please modify the corresponding formula first",
    fieldExist: "[{label}] Field already exists",
    fieldEmpty: "Field is required",
    fieldChar: "Field must begin with a letter"
  },
  validate: {
    type: "Type",
    typePlaceholder: "Please select",
    trigger: "Trigger",
    mode: "Verification method",
    modes: {
      required: "required",
      notRequired: "Not required",
      pattern: "pattern",
      validator: "validator",
      min: "min",
      max: "max",
      len: "length"
    },
    types: {
      string: "String",
      boolean: "Boolean",
      array: "Multiple",
      number: "Number",
      integer: "Integer",
      float: "Float",
      object: "Collection",
      date: "Date",
      url: "Url",
      email: "Email"
    },
    message: "Error",
    auto: "Automatic",
    autoRequired: "Please enter {title}",
    autoMode: "Please enter the correct {title}",
    requiredPlaceholder: "Please enter",
    required: "Is it required",
    rule: "Validation"
  },
  tableOptions: {
    handle: "Operation",
    add: "Add",
    empty1: "Click the lower right corner",
    empty2: "Button to add a column",
    rmCol: "Delete current column",
    rmRow: "Delete current row",
    batchRmCol: "Delete columns",
    batchRmRow: "Delete rows",
    batchSplit: "Split cells",
    batchMerge: "Merge cells",
    splitRow: "Split into rows",
    splitCol: "Split into columns",
    mergeBottom: "Merge downward",
    mergeRight: "Merge right",
    addTop: "Add top column",
    addBottom: "Add the following",
    addLeft: "Add left column",
    addRight: "Add right column",
    keyValue: "key-value"
  },
  struct: {
    title: "Edit",
    only: "[{label}] Only one allowed to be added",
    errorMsg: "The input content is syntactically incorrect",
    configured: "Configured",
    configuredData: "{num} configured",
    configuredEvent: "{num} configured"
  },
  class: {
    title: "Set style",
    create: "Create style",
    placeholder: "Please enter the name of the class",
    saveMsg: "Please save the style you are editing first",
    configured: "{num} configured"
  },
  event: {
    title: "Edit",
    create: "Create",
    list: "List",
    placeholder: "Please enter the name of the event",
    saveMsg: "Please save the event currently being edited",
    type: "Type",
    info: "Info",
    action: "Edit behavior",
    inject: {
      api: "API of current form",
      rule: "Generate rules for the current form",
      self: "Component generation rule",
      option: "Form configuration",
      args: "Original parameters of event"
    }
  },
  flow: {
    event: "Event flow",
    priority: "Priority",
    addConditions: "Add conditions",
    actionConfig: "Configuration action",
    conditionConfig: "Configuration condition",
    configuredCondition: "Configured condition"
  },
  eventInfo: {
    blur: "Triggered when focus is lost",
    focus: "Triggered when focus is obtained",
    change: "Triggered when the binding value changes",
    input: "Trigger when value changes",
    clear: "Triggered when the clear button is clicked",
    close: "Triggered when the component is closed",
    click: "Fires when the component is clicked",
    add: "Trigger when added",
    delete: "Triggered when deleted",
    remove: "Triggered when deleted",
    visibleChange: "Triggered when the drop-down box appears/hides",
    calendarChange: "Triggered when the selected date in the calendar changes",
    panelChange: "Fires when the date panel changes",
    open: "Triggered when opening",
    opened: "Triggered when opening animation ends",
    closed: "Triggered when closing animation ends",
    openAutoFocus: "Triggered when entering focus on content",
    closeAutoFocus: "Triggered when entering focus from content",
    submit: "Triggered when submitting table",
    cancel: "Triggered when the cancel button is clicked",
    confirm: "Triggered when clicking confirm",
    validateFail: "Triggered when table verification fails",
    beforeLoad: "Triggered before initialization",
    loaded: "Triggered after initialization is completed",
    select: "Triggered when any date is clicked and selected",
    unselect: "Triggered when the calendar component's type is multiple, when the date is unselected",
    monthShow: "Triggered when a month enters the visible area",
    hook_load: "Triggered after component rules are loaded",
    hook_mounted: "Triggered after component is mounted",
    hook_deleted: "Triggered after component rules are removed",
    hook_watch: "Triggered after component rules change",
    hook_value: "Triggered after component value changes",
    hook_hidden: "Triggered after component display status changes"
  },
  fetch: {
    info: "When defining a request, variables can be used with double curly braces (e.g., {{token}}). These variables are automatically read during the request. If the variable is an object, its properties can be accessed using {{variableName.attributeName}}.",
    title: "Set data",
    create: "Create data",
    config: "Request",
    action: "Action",
    actionRequired: "Please enter the correct link",
    placeholder: "Please enter the name of the data source",
    method: "Method",
    data: "Data",
    dataType: "DataType",
    headers: "Headers",
    query: "Query",
    parse: "Processing",
    response: "Data returned by the interface",
    onError: "onError",
    beforeFetch: "Before",
    remote: "Remote",
    static: "Static",
    optionsType: {
      fetch: "Fetch",
      global: "Dataset",
      struct: "Static"
    }
  },
  style: {
    width: "Width",
    height: "Height",
    minWidth: "Min Width",
    minHeight: "Min Height",
    maxWidth: "Max Width",
    maxHeight: "Max Height",
    color: "Color",
    backgroundColor: "Background color",
    margin: "Margin",
    padding: "Padding",
    borderRadius: "Border radius",
    border: "Border",
    solid: "Solid",
    dashed: "Dashed",
    dotted: "Dotted",
    double: "Double",
    opacity: "Opacity",
    scale: "Scale",
    overflow: {
      name: "Overflow",
      visible: "Visible",
      hidden: "Hidden",
      scroll: "Scroll",
      auto: "Auto scroll after overflow"
    },
    shadow: {
      name: "Shadow",
      x: "x-axis offset",
      y: "y-axis offset",
      vague: "blurred radius",
      extend: "diffusion radius",
      inset: "inward",
      external: "outward",
      mode: "Mode",
      classic: "Classic",
      flat: "Flat",
      solid: "Stereoscopic"
    },
    display: {
      name: "Display",
      block: "Block",
      "inline-block": "Inline block",
      inline: "Inline",
      flex: "Flex"
    },
    flexDirection: {
      name: "Direction of the spindle",
      row: "The main axis is horizontal and the starting point is on the left",
      "row-reverse": "The main axis is horizontal and the starting point is on the right",
      column: "The main axis is vertical and the starting point is on the upper edge",
      "column-reverse": "The main axis is vertical and the starting point is at the lower edge"
    },
    flexWrap: {
      name: "Whether to wrap",
      nowrap: "No newline",
      wrap: "Newline"
    },
    justifyContent: {
      name: "Alignment on main axis",
      "flex-start": "Left-aligned",
      "flex-end": "Right-aligned",
      center: "Center",
      "space-between": "Align both ends",
      "space-around": "Equal spacing on both sides of child elements",
      "space-evenly": "Child elements are evenly distributed on the main axis"
    },
    alignItems: {
      name: "Alignment of child elements on the cross axis",
      "flex-start": "Align the starting point of the cross axis",
      "flex-end": "Align the end of the cross axis",
      center: "Align the midpoint of the cross axis",
      baseline: "Align along the baseline of the first line of text",
      stretch: "Full the height of the entire container"
    },
    alignContent: {
      name: "Alignment of multi-line child elements on the cross axis",
      "flex-start": "Align with the starting point of the cross axis",
      "flex-end": "Align with the end point of the cross axis",
      center: "Align with the midpoint of the cross axis",
      "space-between": "Align with both ends of the cross axis",
      "space-around": "Multiple rows of sub-elements evenly distributed on the cross axis",
      stretch: "The axis occupies the entire cross axis"
    },
    font: {
      name: "Font",
      size: "Size",
      family: "Family",
      align: "Align",
      height: "line-height",
      spacing: "letter-spacing",
      preview: "Preview"
    },
    family: {
      "Microsoft YaHei": "Microsoft YaHei",
      SimSun: "SimSun",
      SimHei: "SimHei",
      KaiTi: "KaiTi",
      FangSong: "FangSong",
      LiSu: "LiSu"
    },
    position: {
      name: "Position",
      static: "static",
      relative: "relative",
      absolute: "absolute",
      fixed: "fixed",
      sticky: "sticky"
    },
    decoration: {
      name: "Decoration",
      underline: "underline",
      "line-through": "line-through",
      overline: "overline"
    },
    weight: {
      name: "font-weight",
      300: "Fine",
      400: "Default",
      500: "Medium",
      700: "Bold"
    }
  },
  designer: {
    component: "Component",
    id: "Unique id",
    name: "Serial number",
    type: "Type",
    form: "Form",
    json: "Rule",
    style: "Style",
    rule: "Basis",
    advanced: "Advanced",
    props: "Props",
    slots: "Slots",
    customProps: "Custom props",
    validate: "Validate",
    event: "Event",
    search: "Enter keyword to search",
    clearWarn: "It cannot be restored after clearing it. Are you sure you want to clear it? ",
    childEmpty: "Click the \\e789  button in the lower right corner to add a column",
    dragEmpty: "Drag the components from the list on the left here",
    unload: "Are you sure you want to leave the current page?",
    sublist: "Sublist",
    formList: "Form",
    comList: "Component",
    addPage: "Add module",
    pageManage: "Module",
    gridLine: "Auxiliary lines",
    main: "Main",
    print: {
      title: "Print form",
      config: "Configuration",
      left: "Left margin",
      right: "Right margin",
      top: "Top margin",
      bottom: "Bottom margin",
      defaultStyle: "Default",
      wordStyle: "Word",
      export: "Export PDF"
    }
  },
  menu: {
    template: "Template",
    main: "Basic",
    aide: "Auxiliary",
    layout: "Layout",
    component: "Component",
    subform: "Subform",
    container: "Container",
    chart: "Chart",
    tree: "Structure"
  },
  formula: {
    math: "Math",
    string: "Text",
    date: "Date",
    collection: "Collection",
    condition: "Condition",
    feature: "Feature",
    ADD: "Get the value of adding two numbers",
    SUB: "Get the value of the subtraction of two numbers",
    MUL: "Get the value of multiplying two numbers",
    DIV: "Get the value of dividing two numbers",
    SUM: "Get the sum of the values in the collection",
    MAX: "Get the maximum value in the parameter list",
    MIN: "Get the minimum value in the parameter list",
    ABS: "Get the absolute value of a number",
    AVG: "Get the average value of the parameter list",
    POWER: "Get the power of the specified number",
    RAND: "Get a random number greater than or equal to 0 and less than 1",
    PI: "Get PI",
    ROUND: "Round a decimal to the specified number of digits",
    SQRT: "Get the positive square root of a number",
    NOW: "Get the current time",
    TODAY: "Get today date",
    YEAR: "Get the year of the specified date",
    MONTH: "Get the month of the specified date",
    DAY: "Get the number of days on the specified date",
    HOUR: "Get the number of hours on the specified date",
    MINUTE: "Get the minutes of the specified date",
    SECOND: "Get the seconds of the specified date",
    DIFFDAYS: "Get the number of days between two dates",
    DIFFHOURS: "Get the number of hours between two times, keeping two decimal places",
    DIFFMINUTES: "Get the number of minutes between two times",
    ADDYEAR: "Add years to the specified date",
    ADDMONTH: "Add months to the specified date",
    ADDDAY: "Add days to the specified date",
    ADDWEEK: "Add weeks to the specified date",
    ADDHOUR: "Add hours to the specified time",
    ADDMINUTE: "Add minutes to the specified time",
    ADDSECOND: "Add seconds to the specified time",
    SUBYEAR: "Subtract years to the specified date",
    SUBMONTH: "Subtract months to the specified date",
    SUBDAY: "Subtract days to the specified date",
    SUBWEEK: "Subtract weeks to the specified date",
    SUBHOUR: "Subtract hours to the specified time",
    SUBMINUTE: "Subtract minutes to the specified time",
    SUBSECOND: "Subtract seconds to the specified time",
    TIMESTAMP: "Get the timestamp of a specified date",
    STARTSWITH: "Check whether the string starts with the specified string",
    EMPTY: "Check whether the parameter is empty",
    NOTEMPTY: "Check whether the parameter is not empty",
    LEN: "Get the length of the specified collection",
    MOD: "Get the remainder of two numbers",
    FLOOR: "Get the value of the specified number rounded down",
    CEIL: "Get the value of the specified number rounded up",
    FIXED: "Round a decimal to the specified number of decimal places",
    ISNUMBER: "Check whether the parameter is a number",
    TONUMBER: "Convert parameter to number",
    SLICELEFT: "Get a string with a specified length starting from the beginning",
    SLICERIGHT: "Get a string with a specified length starting from the end",
    TOLOWER: "Convert all uppercase letters in the string to lowercase letters",
    TOUPPER: "Convert all lowercase letters in the string to uppercase letters",
    INCLUDES: "Check whether the string contains the specified string",
    REPLACE: "Replace part of the text in the string with different text, only replacing the first match",
    REPLACEALL: "Replace part of the text in the string with different text, replacing all matches",
    TRIM: "Remove spaces before and after the string",
    TOCHINSESAMOUNT: "Get the Chinese capital amount of the specified number",
    UNION: "Deduplicate the values in the collection/parameters and return the deduplicated collection",
    INTERSECTIONSET: "Get the intersection of two collections",
    LIST: "Get a collection of all parameters",
    AND: 'Link expressions with "AND", return true when all expressions are true, otherwise return false',
    OR: 'Link expressions with "OR", return true when one expression is true, otherwise return false',
    IF: "Check whether a condition is met, return the second parameter if it is met, otherwise return the third parameter",
    IN: "Check whether the second parameter is in the collection",
    DEFAULT: "Check the first parameter, return the second parameter if it is empty, otherwise return the first parameter",
    CASE: "Check whether one or more conditions are met and return the first value that meets the conditions",
    COLUMN: "Get the specified fields in the subform and return the collection",
    VALUE: "Get the specified field in the group form",
    CONCAT: "Concatenate all parameters and return the concatenated string",
    FALSE: "Return logical value false",
    TRUE: "Return logical value true",
    NOT: "Get the opposite value of a logical value",
    EQ: "Check if two values are equal",
    NE: "Check if two values are not equal",
    GE: "Check if the first value is greater than or equal to another value",
    GT: "Check if the first value is greater than another value",
    LE: "Check if the first value is less than or equal to another value",
    LT: "Check if the first value is less than another value",
    DEFAULT_VALUE: "Set the default value of the current component",
    CALLBACK: "Execute a custom function and get the return value",
    GET_DATA: "Get external data",
    GET_VARIABLE: "Get global variable data",
    CURRENT_RULE: "Get the specified field in the current component rule",
    T: "Get the specified field in the multi-language configuration"
  },
  language: {
    name: "Language",
    add: "Add",
    batchRemove: "Batch Deletion",
    select: "Select language"
  },
  props: {
    start: "Start",
    end: "End",
    action: "Action",
    condition: "Condition",
    circle: "Circle",
    square: "Square",
    image: "Image",
    video: "Video",
    audio: "Audio",
    document: "Document",
    size: "Size",
    info: "Info",
    success: "Success",
    error: "Error",
    warning: "Warning",
    primary: "Primary",
    danger: "Danger",
    form: "Form",
    subform: "Subform",
    other: "Other",
    model: "Model",
    field: "Field",
    page: "Page",
    variable: "Variable",
    disabled: "Disabled",
    enable: "Enable",
    time: "time",
    email: "email",
    number: "number",
    globalData: "Global data",
    title: "Title",
    content: "Content",
    collection: "Collection",
    group: "Group",
    custom: "Custom",
    change: "Change",
    blur: "Blur",
    preview: "Preview",
    clear: "Clear",
    cancel: "Cancel",
    close: "Close",
    ok: "Ok",
    save: "Save",
    refresh: "Refresh",
    submit: "Submit",
    reset: "Reset",
    copy: "Copy",
    delete: "Delete",
    hide: "Hidden",
    show: "Show",
    position: "Position",
    render: "Render",
    large: "large",
    medium: "medium",
    default: "default",
    small: "small",
    mini: "mini",
    always: "always",
    single: "single",
    multiple: "multiple",
    range: "range",
    never: "never",
    hover: "hover",
    click: "click",
    button: "button",
    year: "year",
    month: "month",
    day: "day",
    hour: "hour",
    minute: "minute",
    second: "second",
    date: "date",
    dates: "dates",
    week: "week",
    datetime: "datetime",
    "datetime-local": "datetime",
    datetimerange: "datetimerange",
    daterange: "daterange",
    monthrange: "monthrange",
    left: "left",
    right: "right",
    top: "top",
    bottom: "bottom",
    round: "round",
    card: "card",
    line: "line",
    text: "text",
    icon: "icon",
    picture: "picture",
    "picture-card": "picture-card",
    center: "center",
    vertical: "vertical",
    horizontal: "horizontal",
    manage: "Manage",
    key: "key",
    name: "Name",
    value: "Value",
    inputData: "Default value",
    append: "Append",
    options: "Options",
    option: "Option",
    closeable: "closeable",
    callback: "Callback",
    noData: "No Data",
    link: "link",
    mode: "Mode",
    style: "Style",
    print: "Print",
    auto: "Automatic",
    _self: "Current Window",
    _blank: "New Window",
    _parent: "Parent Window",
    _top: "Top Window"
  },
  slots: {
    "left-icon": "Prefix",
    "right-icon": "Suffix",
    extra: "Extra"
  },
  behavior: {
    add: "Add action",
    props: {
      id: "Component",
      status: "Status",
      compute: "Condition",
      static: "Static",
      formula: "Expression",
      setFormula: "Configure expression",
      continue: "Continue execution",
      stop: "Interrupt execution",
      break: "Skip current",
      model: "Model",
      fetch: "Request",
      response: "Request result",
      callback: "Custom JS",
      ignoreError: "Exception",
      expression: "Execution condition",
      stopPropagation: "Blocking condition",
      execute: "Execute action",
      info: "Action description"
    },
    redirectPage: {
      name: "Redirect",
      info: "Redirect to the specified page",
      location: "Redirect url",
      router: "Redirect route",
      props: {
        break: "Open a new page",
        type: "Method",
        url: "Page url"
      },
      warning: {
        type: "Routing redirect is used in single-page applications to switch and redirect pages by setting access paths, while link redirect is a traditional browser page redirect."
      }
    },
    reloadPage: {
      name: "Refresh",
      info: "Refresh the current page"
    },
    openModel: {
      name: "Open pop-up window",
      info: "Open the selected pop-up window"
    },
    closeModel: {
      name: "Close pop-up window",
      info: "Close the current pop-up window"
    },
    hidden: {
      name: "Component visibility",
      info: "Control the display/hide of the selected component"
    },
    disabled: {
      name: "Component availability",
      info: "Control the enable/disable of the selected component"
    },
    resetFields: {
      name: "Reset form",
      info: "Reset form data"
    },
    clearFields: {
      name: "Clear form",
      info: "Clear form data"
    },
    validate: {
      name: "Validate form",
      info: "Validate the contents of the entire form"
    },
    validateFields: {
      name: "Validate form items",
      info: "Validate selected form items"
    },
    setValue: {
      name: "Form assignment",
      info: "Modify form data"
    },
    fetch: {
      name: "Send request",
      info: "Configure and send API request",
      props: {
        append: "Append formData"
      },
      warning: {
        append: "When enabled, the data from the remote request will be automatically appended to the form data.",
        response: "The data from the remote request will be temporarily stored in the specified variable."
      }
    },
    copy: {
      name: "Copy content",
      info: "Copy text content to the clipboard"
    },
    callback: {
      name: "Custom operation",
      info: "Customize action logic through JavaScript"
    },
    message: {
      name: "Message reminder",
      info: "Pop-up message reminder",
      props: {
        type: "Type",
        message: "Message",
        duration: "Duration (ms)",
        showClose: "Show close button"
      }
    },
    submit: {
      name: "Submit form",
      info: "Manually submit the form and trigger the form submission event"
    }
  },
  com: {
    cascader: {
      name: "Cascader",
      event: {
        finish: "Triggered after all options are selected",
        clickTab: "Triggered when clicking a tab"
      },
      props: {
        title: "Top title",
        placeholder: "Input box placeholder text",
        disabled: "Disabled",
        activeColor: "Highlight color of the selected state",
        clearable: "Whether to enable the clear icon"
      }
    },
    checkbox: {
      name: "Checkbox",
      props: {
        disabled: "Disabled",
        max: "The maximum number of checkboxes that can be checked",
        checkedColor: "The color of all checkboxes when they are checked",
        direction: "Arrangement direction"
      }
    },
    col: {
      name: "Col",
      props: {
        span: "The number of columns occupied by the grid",
        offset: "The number of grids on the left side of the grid"
      }
    },
    datePicker: {
      name: "Date",
      type: {
        date: "date",
        "year-month": "year-month",
        "month-day": "month-day",
        datehour: "datehour",
        datetime: "datetime"
      },
      props: {
        disabled: "Disabled",
        clearable: "Whether to enable the clear icon",
        type: "Type",
        minDate: "Minimum available time",
        maxDate: "Maximum available time",
        title: "Top bar title",
        visibleOptionNum: "Number of visible options",
        placeholder: "Prompt text when unselected"
      }
    },
    calendar: {
      name: "Calendar",
      props: {
        disabled: "Disabled",
        type: "Option type",
        title: "Calendar title",
        minDate: "Minimum selectable time",
        maxDate: "Maximum selectable time",
        placeholder: "Prompt text when not selected",
        clearable: "Whether to enable the clear icon"
      }
    },
    calendarRange: {
      name: "dateRange"
    },
    vanNoticeBar: {
      name: "Notice",
      description: "Notification text",
      event: {
        replay: "Triggered every time the scroll bar starts scrolling again"
      },
      props: {
        mode: "Notification bar mode",
        text: "Notification text content",
        color: "Notification text color",
        background: "Scroll bar background",
        speed: "Scrolling speed",
        scrollable: "Whether to enable scrolling, enabled by default when the content length overflows",
        wrapable: "Whether to enable text wrapping, only effective when scrolling is disabled"
      }
    },
    vanButton: {
      name: "Button",
      props: {
        formCreateChild: "Content",
        size: "Size",
        type: "Type",
        color: "Button color",
        block: "Is it a block-level element",
        square: "Is it a square button",
        round: "Is it a round button",
        disabled: "Is the button disabled"
      }
    },
    vanCollapse: {
      name: "Collapse",
      event: {
        change: "Triggered when switching panels"
      },
      props: {
        accordion: "Whether accordion mode"
      }
    },
    vanCollapseItem: {
      name: "CollapseItem",
      props: {
        title: "Content on the left side of the title bar",
        name: "Unique identifier",
        value: "Content on the right side of the title bar",
        label: "Title bar description information",
        disabled: "Whether to disable the panel"
      }
    },
    vanDivider: {
      name: "Divider",
      props: {
        formCreateChild: "Set the dividing line text",
        dashed: "Whether to use dashed line",
        contentPosition: "Content position"
      }
    },
    vanTab: {
      name: "Tab",
      props: {
        title: "Tab title",
        disabled: "Disabled",
        name: "Tab identifier"
      }
    },
    vanTabs: {
      name: "Tabs",
      event: {
        click: "Trigger when clicking on a tab",
        rendered: "Trigger when the tab content is first rendered (only triggered after delayed rendering is turned on)",
        scroll: "Trigger when scrolling, only works in sticky mode"
      },
      props: {
        type: "Style type",
        color: "Tag theme color",
        background: "Tab bar background color",
        sticky: "Whether to use sticky layout",
        swipeable: "Whether to enable gesture swipe left and right",
        scrollspy: "Whether to enable scroll navigation",
        titleActiveColor: "Title selected state color",
        titleInactiveColor: "Title default state color"
      }
    },
    vanTag: {
      name: "Tag",
      props: {
        formCreateTitle: "Title",
        formCreateChild: "Tag content",
        type: "Tag type",
        size: "Tag size",
        color: "Tag color",
        plain: "Whether it is hollow style",
        round: "Whether it is rounded style",
        textColor: "Text color"
      }
    },
    vanImage: {
      name: "Image",
      props: {
        src: "Image path"
      }
    },
    fcTitle: {
      name: "Title",
      props: {
        title: "Title",
        size: "Size",
        align: "Align"
      }
    },
    fcId: {
      name: "ID",
      props: {
        prefix: "Prefix"
      }
    },
    fcCity: {
      name: "Province picker",
      props: {
        api: "URI",
        level: "Level",
        clearable: "Whether to display the clear button",
        disabled: "Disabled",
        filter: "Data filtering, return selectable data"
      }
    },
    fcCell: {
      name: "Cell"
    },
    fcEditor: {
      name: "Editor",
      props: {
        disabled: "Disabled"
      }
    },
    fcFlex: {
      name: "Flex"
    },
    fcFlex2: {
      name: "Flex",
      horizontal: "Horizontal Center",
      vertical: "Vertical Center",
      left: "Left align",
      right: "Right align",
      reset: "Reset layout"
    },
    fcRow: {
      name: "Row",
      props: {
        gutter: "Grid interval",
        justify: "Horizontal alignment",
        align: "Vertical alignment"
      }
    },
    fcPopup: {
      name: "Popup",
      event: {
        clickCloseIcon: "Triggered when clicking the close icon"
      },
      props: {
        title: "Title",
        position: "Popup position",
        beforeClose: "Callback function before closing",
        footer: "Whether to show operation buttons",
        autoClose: "Automatically close the popup after submitting the form"
      }
    },
    fcTable: {
      name: "Table",
      props: {
        mini: "Compact Mode",
        border: "Whether to display border",
        borderColor: "Border color",
        borderWidth: "Border width"
      }
    },
    fcTableGrid: {
      name: "Grid"
    },
    fcValue: {
      name: "Computed",
      empty: "Set the calculation formula in the right configuration"
    },
    fcSlot: {
      name: "Slot",
      empty: "Define&nbsp;{tag}&nbsp;slot",
      props: {
        name: "Slot Name"
      }
    },
    fcJson: {
      name: "Dynamic",
      empty: "Populate a zone by loading&nbsp;{tag}&nbsp;rules",
      props: {
        _loadType: "JSON Rules",
        type: "Type"
      }
    },
    lineChart: {
      name: "Line Chart",
      data: "Chart Data",
      pieTypeOpt: {
        pie: "Pie",
        doughnut: "Doughnut",
        "half-doughnut": "Half-doughnut"
      },
      funnelSortOpt: {
        descending: "descending",
        ascending: "ascending"
      },
      props: {
        title: "Chart name",
        subtitle: "Chart introduction",
        valueFormat: "Format numerical display",
        stack: "Whether to stack when there are multiple columns of data",
        smooth: "Whether the line transitions smoothly",
        showLegend: "Whether to display the mark",
        showSeriesLabel: "Whether to display the value",
        barBackgroundColor: "Column background color",
        funnelSort: "Sort method",
        pieType: "Shape",
        min: "Minimum value",
        max: "Maximum value",
        value: "Number",
        indicator: "Indicator",
        loadOptions: "Initialization"
      }
    },
    areaChart: {
      name: "Area Chart"
    },
    barChart: {
      name: "Bar Chart"
    },
    customChart: {
      name: "Custom Chart"
    },
    funnelChart: {
      name: "Funnel Chart"
    },
    gaugeChart: {
      name: "Gauge Chart"
    },
    pieChart: {
      name: "Pie Chart"
    },
    radarChart: {
      name: "Radar Chart"
    },
    scatterChart: {
      name: "Scatter Chart"
    },
    stripeChart: {
      name: "Horizontal bar Chart"
    },
    group: {
      name: "Subform",
      props: {
        disabled: "Disabled",
        expand: "Set the default expansion items",
        button: "Whether to display the operation button",
        sortBtn: "Whether to display the sort button",
        min: "Set the minimum number of items to add",
        max: "Set the maximum number of items to add"
      }
    },
    html: {
      name: "HTML",
      props: {
        formCreateTitle: "Title",
        formCreateChild: "Content"
      }
    },
    input: {
      name: "Input",
      props: {
        type: "Type",
        disabled: "Disable",
        readonly: "Readonly",
        placeholder: "Input box placeholder prompt text",
        maxlength: "The maximum number of characters to enter",
        showWordLimit: "Whether to display word count",
        clearable: "Whether to enable the clear icon",
        autosize: "Whether to adapt to the content height",
        rows: "Number of input box rows"
      }
    },
    stepper: {
      name: "Stepper",
      event: {
        overlimit: "Triggered when clicking an unavailable button",
        plus: "Triggered when clicking the increase button",
        minus: "Triggered when clicking the decrease button"
      },
      props: {
        min: "Minimum value",
        max: "Maximum value",
        step: "Step length",
        decimalLength: "Fixed number of decimal places displayed",
        theme: "Style",
        placeholder: "Input box placeholder prompt text",
        integer: "Is only integer allowed to be entered",
        disabled: "Disabled"
      }
    },
    password: {
      name: "Password"
    },
    radio: {
      name: "Radio",
      props: {
        disabled: "Disabled",
        max: "Maximum selectable number, 0 means unlimited",
        checkedColor: "Checked color of all checkboxes",
        direction: "Arrangement direction"
      }
    },
    rate: {
      name: "Rate",
      props: {
        count: "Maximum score",
        disabled: "Disabled",
        readonly: "Readonly",
        allowHalf: "Is it allowed to be half-selected",
        color: "Color when selected",
        voidColor: "Color when unselected"
      }
    },
    select: {
      name: "Select",
      event: {
        clickOption: "Triggered when clicking an option",
        scrollInto: "Triggered when the user clicks or drags an option to scroll to the middle selection area"
      },
      props: {
        disabled: "Disabled",
        readonly: "Readonly",
        title: "Top bar title",
        visibleOptionNum: "Number of visible options"
      }
    },
    slider: {
      name: "Slider",
      event: {
        dragStart: "Trigger when dragging starts",
        dragEnd: "Trigger when dragging ends"
      },
      props: {
        disabled: "Disabled",
        readonly: "Readonly",
        range: "Range selection",
        max: "Maximum value",
        min: "Minimum value",
        step: "Step length"
      }
    },
    space: {
      name: "Space"
    },
    stepForm: {
      name: "StepForm",
      event: {
        next: "Triggered when the next button is clicked"
      },
      props: {
        submitBtn: "Show submit button",
        autoValidate: "Automatically validate the form before entering the next step",
        "stepsProps>activeColor": "The color of the current step and completed steps",
        "stepsProps>inactiveColor": "The color of the inactive step"
      }
    },
    stepFormItem: {
      name: "StepFormItem",
      props: {
        title: "Title"
      }
    },
    subForm: {
      name: "Group",
      props: {
        disabled: "Disabled"
      }
    },
    switch: {
      name: "Switch",
      props: {
        disabled: "Disabled",
        activeColor: "Background color when turned on",
        inactiveColor: "Background color when turned off",
        activeValue: "Value when turned on",
        inactiveValue: "Value when turned off"
      }
    },
    tableForm: {
      name: "TableForm",
      props: {
        disabled: "Disabled",
        addable: "Allow to add",
        deletable: "Allow delete",
        filterEmptyColumn: "Whether to filter empty rows",
        max: "Maximum number of rows to add, if 0, there is no limit",
        min: "Minimum number of rows to add"
      }
    },
    tableFormColumn: {
      name: "TableFormColumn",
      label: "TableFormColumn",
      props: {
        align: "Align",
        label: "Title",
        width: "Width",
        color: "Color",
        required: "Whether to display required asterisks"
      }
    },
    text: {
      name: "Text",
      props: {
        formCreateTitle: "Title",
        formCreateChild: "Content"
      }
    },
    textarea: {
      name: "Textarea"
    },
    timePicker: {
      name: "Time",
      props: {
        disabled: "Disabled",
        clearable: "Whether to enable the clear icon",
        minTime: "Optional minimum time",
        maxTime: "Optional maximum time",
        title: "Top bar title",
        visibleOptionNum: "Visible number of options",
        placeholder: "Prompt text when not selected"
      }
    },
    uploader: {
      name: "Uploader",
      info: "After a successful upload, assign the returned URL to file.url or the result to file.value for use in subsequent form submissions.",
      event: {
        oversize: "Trigger when the file size exceeds the limit",
        clickUpload: "Trigger when clicking the upload area",
        clickPreview: "Trigger when clicking the preview image",
        clickReupload: "Trigger when clicking to overwrite the upload",
        closePreview: "Trigger when closing the full-screen image preview",
        delete: "Trigger when deleting the file preview"
      },
      props: {
        disabled: "Whether to disable",
        action: "Upload address (required)",
        onSuccess: "Upload success callback",
        beforeDelete: "Callback before file deletion",
        headers: "Set the upload request header",
        data: "Additional parameters attached to the upload",
        uploadName: "Uploaded file field name",
        maxCount: "File upload limit",
        maxSize: "File size limit, unit is byte",
        accept: "File types allowed to be uploaded"
      }
    },
    vanCellGroup: {
      name: "CellGroup",
      props: {
        title: "Title",
        inset: "Whether to display as rounded card style",
        border: "Whether to display outer border"
      }
    },
    vanCell: {
      name: "Cell",
      props: {
        title: "Title",
        value: "Content",
        label: "Description information below the title",
        icon: "Left icon name or image link",
        url: "Click to redirect to the link address",
        isLink: "Whether to display the right arrow and enable click feedback",
        center: "Whether to vertically center the content"
      }
    },
    vanIcon: {
      name: "Icon",
      props: {
        name: "Icon name or image link",
        dot: "Whether to display the small red dot in the upper right corner of the icon",
        badge: "Content of the logo in the upper right corner of the icon",
        color: "Icon color",
        size: "Icon size"
      }
    },
    vanField: {
      name: "FormItem",
      props: {
        label: "Label",
        labelWidth: "Label Width"
      }
    },
    audioBox: {
      name: "AudioPlayer",
      preloadOpt: {
        auto: "Auto",
        metadata: "Metadata",
        none: "None"
      },
      event: {
        pause: "Triggered when audio playback is paused",
        play: "Triggered when audio starts playing",
        ended: "Triggered when the audio playback ends"
      },
      props: {
        src: "Audio path",
        type: "Audio Type",
        autoplay: "Whether to play automatically",
        loop: "Whether to loop playback",
        muted: "Whether to mute",
        controls: "Whether to display the control bar",
        preload: "Preload"
      }
    },
    barCodeBox: {
      name: "Barcode",
      props: {
        value: "Content",
        format: "Barcode type",
        width: "Width of a single bar",
        height: "Height of the barcode",
        displayValue: "Whether to display content",
        fontSize: "Set text size",
        textPosition: "Set text position",
        textAlign: "Set text alignment",
        textMargin: "Set text margin",
        background: "Background color",
        lineColor: "Line color"
      }
    },
    iframeBox: {
      name: "Iframe",
      event: {
        load: "Trigger after page loading"
      },
      loadingOpt: {
        eager: "Load immediately",
        lazy: "Lazy loading"
      },
      props: {
        src: "Website URL",
        loading: "Loading method"
      }
    },
    qrCodeBox: {
      name: "QR Code",
      circleTypeOpt: {
        square: "Square",
        dots: "Dots",
        rounded: "Rounded",
        classy: "Classy"
      },
      props: {
        data: "Content",
        image: "Center image path",
        width: "Width of QR code",
        height: "Height of QR code",
        circleType: "Dots type",
        circleColor: "Dots color"
      }
    },
    signaturePad: {
      name: "Signature",
      props: {
        penColor: "Line color",
        disabled: "Disabled"
      }
    },
    videoBox: {
      name: "Video",
      event: {
        error: "Triggered when video loading fails",
        pause: "Triggered when video playback is paused",
        play: "Triggered when video starts playing",
        ended: "Triggered after video playback ends"
      },
      props: {
        src: "Video path",
        type: "Video type",
        autoplay: "Whether to play automatically",
        loop: "Whether to play in a loop",
        isLive: "Whether to broadcast live",
        controls: "Whether to display the control bar",
        withCredentials: "Whether to carry credentials"
      }
    }
  },
  tmp: {
    duration: "duration",
    chineseAmount: "chineseAmount",
    col3: "3-Col",
    col4: "4-Col",
    table43: "4x3Table"
  }
};
export {
  e as default
};
