<p align="center">
    <a href="https://www.form-create.com">
        <img width="300" alt="FormCreate" src="https://static.form-create.com/file/img/info-logo2.png">
    </a>
</p>

<p align="center">
    <a href="https://www.form-create.com/" target="_blank">官网</a>
    <span>&nbsp;|&nbsp;</span>
    <a href="https://pro.form-create.com/doc/" target="_blank">帮助文档</a>
    <span>&nbsp;|&nbsp;</span>
    <a href="https://pro.form-create.com/view/" target="_blank">可视化表单设计器</a>
</p>

**FcDesigner Mobile版是一款基于Vue的移动端低代码可视化表单设计器工具，通过数据驱动表单渲染。可以通过拖拽的方式快速创建表单，提高开发者对表单的开发效率，节省开发者的时间。目前，在OA系统、ERP系统、电商系统、流程管理等系统中已稳定应用。**

-----
本项目采用 Vue2.7 和 ElementUI 进行页面构建，移动端采用Vant2.0，内置多语言解决方案，支持二次扩展开发，支持自定义组件扩展。


## 特点
- 多语言配置
  > 轻松在设计器中为表单各元素添加多语种文本，一键切换语言体系，打破语言隔阂，拓展全球业务版图，使您在应对全球化的过程中无忧无虑，轻松自如。

- 绑定事件
  > 产品提供了可配置的组件和表单事件功能，为您处理各种动态交互提供了便利。无论用户需求何种复杂度与多样性，我们都能迎刃而解，提供满足使用者需求的解决方案。

- 丰富的组件
  > 产品内置了50+种常用组件，广泛覆盖多种场景需求，以满足不同的用户需求。更为重要的是，我们支持灵活扩展自定义组件，以满足您独特、个人化的需求，为您提供更丰富的使用体验。

- 灵活的布局
  > 产品提供了多种复杂表单布局方式，包括栅格、弹性盒子、表格等，这些功能让复杂的表单布局变得趋于简洁明了。此举不仅拓宽用户选择范围，更是为用户提供了贴心可靠的使用体验。

- 阅读模式
  > 致力于实现表单编辑与数据查看模式的无缝切换，高效地提升代码复用性。这种改进将大大提高生产效率，同时也能让用户在任何情况下都能享受到流畅的使用体验。

- 公式计算
  > 内置了52种常用的函数计算公式，这不仅可以大幅度提高数据分析效率，而且也能够灵活满足您在实际业务中的特定计算需求，从而保证数据的准确有效性。

- 数据联动
  > 提供更灵活的条件设置和组件值联动功能。用户可为组件设置条件，条件满足时触发联动显示，例如动态展示其他组件的值，实现组件间值的实时同步。

- 可视化
  > 产品以可视化操作为主导，使您可以轻而易举地完成表单页面的编辑。通过直观的图形界面，无需深入繁琐复杂的代码便可完成操作，大大降低了使用门槛，让编辑工作变得更轻松、更高效。

- 行内布局
  > 行内布局功能打破传统表单组件单一纵向堆叠模式，通过简洁直观的操作界面，允许开发者自由拖拽组件，使其能够在同一行内 “并肩齐驱”。
  
## 编译文件

```
├─dist 编译文件目录
│ ├─index.[es|umd].js 移动端表单设计器
│ ├─mobile/form-create.vant.[es|umd].js 移动端runtime环境的渲染器, 无需导入设计器
│
```

## 命令说明

运行开发环境
```
pnpm run dev
```

完整打包设计器
```
pnpm run build
```

打包多语言文件
```
pnpm run build:locale
```

打包移动端渲染器
```
pnpm run build:mobile
```

打包预览页面,输出 index.html
```
pnpm run build:preview
```


## 版权声明

FcDesigner Mobile是由西安锦强未来科技有限公司的FormCreate团队负责的更新与维护，若需在您的项目中应用，需购买我们[授权](https://www.form-create.com/price.html)。

## 联系

![http://static.form-create.com/file/img/support.jpg](http://static.form-create.com/file/img/support.jpg)
