// +-----------------------------------------------------------------------
// | FormCreate商业版 [ 让表单设计更简单 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2018~2025 https://form-create.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed FormCreate商业版并不是自由软件，未经授权不得使用、修改或移除版权信息
// +----------------------------------------------------------------------
// | Author: FormCreate Team <admin@form-create.com>
// +----------------------------------------------------------------------
import FcDesignerMobile from './components/FcDesigner.vue';
import DragTool from './components/DragTool.vue';
import Struct from './components/Struct.vue';
import HtmlEditor from './components/HtmlEditor.vue';
import FnEditor from './components/FnEditor.vue';
import SizeInput from './components/style/SizeInput.vue';
import ColorInput from './components/style/ColorInput.vue';
import FieldInput from './components/FieldInput.vue';
import PromptInput from './components/PromptInput.vue';
import ValueInput from './components/computed/ValueInput.vue';
import PatternInput from './components/computed/PatternInput.vue';
import StyleConfig from './components/style/StyleConfig.vue';
import ComputedConfig from './components/computed/ComputedConfig.vue';
import EventConfig from './components/EventConfig.vue';
import FetchConfig from './components/FetchConfig.vue';
import FnConfig from './components/FnConfig.vue';
import FnInput from './components/FnInput.vue';
import GlobalFetchConfig from './components/GlobalFetchConfig.vue';
import GlobalFetchSelect from './components/GlobalFetchSelect.vue';
import GlobalEventConfig from './components/GlobalEventConfig.vue';
import GlobalClassConfig from './components/GlobalClassConfig.vue';
import GlobalClassSelect from './components/GlobalClassSelect.vue';
import GlobalVariableConfig from './components/GlobalVariableConfig.vue';
import VariableConfig from './components/computed/VariableConfig.vue';
import FetchTable from './components/FetchTable.vue';
import TableView from './components/table/TableView.vue';
import Table from './components/table/Table.vue';
import ValueView from './components/value/ValueView.vue';
import Value from './components/value/Value.vue';
import Slot from './components/slotComponent/SlotComponent.vue';
import SlotView from './components/slotComponent/SlotComponentView.vue';
import Json from './components/jsonComponent/JsonComponent.vue';
import JsonView from './components/jsonComponent/JsonComponentView.vue';
import Validate from './components/Validate.vue';
import DragBox from './components/DragBox.vue';
import Required from './components/Required.vue';
import TableOptions from './components/TableOptions.vue';
import TreeOptions from './components/TreeOptions.vue';
import StepForm from './components/stepForm/StepForm.vue';
import StepFormView from './components/stepForm/StepFormView.vue';
import TableFormView from './components/tableForm/TableFormView.vue';
import TableForm from './components/tableForm/TableForm.vue';
import TableFormColumnView from './components/tableForm/TableFormColumnView.vue';
import StepFormItemView from './components/stepForm/StepFormItemView.vue';
import PopupView from './components/popup/PopupView.vue';
import Popup from './components/popup/Popup.vue';
import Cell from './components/cell/Cell.vue';
import CellView from './components/cell/CellView.vue';
import Row from './components/Row.vue';
import ConfigItem from './components/style/ConfigItem.vue';
import ConfigTitle from './components/style/ConfigTitle.vue';
import RuleSelect from './components/RuleSelect.vue';
import HideConfig from './components/HideConfig.vue';
import LanguageInput from './components/language/LanguageInput.vue';
import AudioBox from './components/aide/AudioBox.vue';
import VideoBox from './components/aide/VideoBox.vue';
import BarCodeBox from './components/aide/BarCodeBox.vue';
import IframeBox from './components/aide/IframeBox.vue';
import QrCodeBox from './components/aide/QrCodeBox.vue';
import FcCity from './components/City.vue';
import SignaturePad from './components/SignaturePad.vue';
import Echarts from './components/echarts/Echarts.vue';
import FcFlow from './utils/flow/index.js';
import Id from './components/Id.vue';
import FcTitle from './components/aide/FcTitle.vue';
import FcMarkdown from './components/aide/Markdown.vue';
import formCreate, {designerForm, elmFormCreate} from './utils/form';
import draggable from 'vuedraggable/src/vuedraggable';
import {
    compareVersion,
    copyTextToClipboard,
    getInjectArg,
    localeOptions,
    localeProps,
    makeDataRule,
    makeOptionsRule,
    makeRequiredRule,
    makeTitleRule,
    makeTreeOptions,
    makeTreeOptionsRule,
    toJSON
} from './utils/index';
import globalUseLocale, {locale, t} from './utils/locale';
import CodeMirror from 'codemirror';
import 'codemirror/addon/mode/simple';
import './style/index.css';
import './style/theme.css';
import './style/icon.css';
import './form/mobile.css';
import './utils/highlight/style.css';
import formulas, {formulaInfo, formulaTree} from './utils/formulas';
import {behavior, behaviorRules, behaviorTree} from './utils/behavior';
import loadjs from './utils/loadjs/loadjs';
import menus from './config/menu';
import dragRuleList from './config/index';
import setting from './extension/setting';

CodeMirror.defineSimpleMode('fcComputedMode', {
    start: [
        {regex: /[a-zA-Z_]\w*/, token: 'keyword'},
        {regex: /[a-z]+/, token: 'def'},
        {regex: /\/\/.*/, token: 'comment'},
        {regex: /\/\*/, token: 'comment', next: 'comment'},
        {regex: /[-+]?(\d*\.)?\d+/, token: 'number'},
        {regex: /"(?:[^\\]|\\.)*?(?:"|$)/, token: 'string'},
        {regex: /[\(\),]/, token: 'bracket'},
        {regex: /==/, token: 'operator'},
        {regex: /=/, token: 'operator'},
        {regex: /[!<>]=?/, token: 'operator'},
        {regex: /&&|\|\|/, token: 'operator'},
        {regex: /[\+\-\*\%\/]/, token: 'builtin'},
    ],
    comment: [
        {regex: /.*?\*\//, token: 'comment', next: 'start'},
        {regex: /.*/, token: 'comment'},
    ],
});

const addComponent = (id, component, previewComponent) => {
    designerForm.component(id, previewComponent || component);
    formCreate.component(id, component);
}

designerForm.component('DragTool', DragTool);
designerForm.component('DragBox', DragBox);
elmFormCreate.component('draggable', draggable);
elmFormCreate.component('DragTool', DragTool);
elmFormCreate.component('DragBox', DragBox);
elmFormCreate.component('Validate', Validate);
elmFormCreate.component('Struct', Struct);
elmFormCreate.component('HtmlEditor', HtmlEditor);
elmFormCreate.component('FnEditor', FnEditor);
elmFormCreate.component('ComputedConfig', ComputedConfig);
elmFormCreate.component('Required', Required);
elmFormCreate.component('TableOptions', TableOptions);
elmFormCreate.component('TreeOptions', TreeOptions);
elmFormCreate.component('EventConfig', EventConfig);
elmFormCreate.component('FetchConfig', FetchConfig);
elmFormCreate.component('SizeInput', SizeInput);
elmFormCreate.component('PatternInput', PatternInput);
elmFormCreate.component('StyleConfig', StyleConfig);
elmFormCreate.component('GlobalFetchConfig', GlobalFetchConfig);
elmFormCreate.component('GlobalFetchSelect', GlobalFetchSelect);
elmFormCreate.component('GlobalEventConfig', GlobalEventConfig);
elmFormCreate.component('GlobalClassConfig', GlobalClassConfig);
elmFormCreate.component('GlobalClassSelect', GlobalClassSelect);
elmFormCreate.component('GlobalVariableConfig', GlobalVariableConfig);
elmFormCreate.component('FetchTable', FetchTable);
elmFormCreate.component('VariableConfig', VariableConfig);
elmFormCreate.component('ColorInput', ColorInput);
elmFormCreate.component('ConfigItem', ConfigItem);
elmFormCreate.component('ConfigTitle', ConfigTitle);
elmFormCreate.component('HideConfig', HideConfig);
elmFormCreate.component('FieldInput', FieldInput);
elmFormCreate.component('PromptInput', PromptInput);
elmFormCreate.component('ValueInput', ValueInput);
elmFormCreate.component('FnConfig', FnConfig);
elmFormCreate.component('FnInput', FnInput);
elmFormCreate.component('RuleSelect', RuleSelect);
elmFormCreate.component('LanguageInput', LanguageInput);
elmFormCreate.component('FcFlow', FcFlow);
designerForm.component('StepFormItem', StepFormItemView);
designerForm.component('TableFormColumn', TableFormColumnView);
designerForm.component('FcRow', Row);
addComponent('FcSlot', Slot, SlotView);
addComponent('FcJson', Json, JsonView);
addComponent('FcCell', Cell, CellView);
addComponent('TableForm', TableForm, TableFormView);
addComponent('StepForm', StepForm, StepFormView);
addComponent('FcValue', Value, ValueView);
addComponent('FcTable', Table, TableView);
addComponent('FcPopup', Popup, PopupView);
addComponent('AudioBox', AudioBox);
addComponent('VideoBox', VideoBox);
addComponent('BarCodeBox', BarCodeBox);
addComponent('IframeBox', IframeBox);
addComponent('QrCodeBox', QrCodeBox);
addComponent('SignaturePad', SignaturePad);
addComponent('FcEcharts', Echarts);
addComponent('FcTitle', FcTitle);
addComponent('FcCity', FcCity);
addComponent('FcId', Id);
addComponent('FcMarkdown', FcMarkdown);

const setFormula = function (formula) {
    const _formulas = Array.isArray(formula) ? formula : [formula];
    _formulas.forEach(item => {
        formulas[item.name] = item.handle;
        formulaInfo[item.name] = item.example;
        locale.value.formula[item.name] = item.info;
        formulaTree.forEach(menu => {
            if (menu.key === item.menu) {
                menu.children.push(item.name);
            }
            formCreate.setFormula(item.name, item.handle);
            designerForm.setFormula(item.name, item.handle);
        });
    });
}

const setBehavior = function (behaviors) {
    const _behaviors = Array.isArray(behaviors) ? behaviors : [behaviors];
    _behaviors.forEach(item => {
        behavior[item.name] = item.handle;
        behaviorRules[item.name] = item.rule;
        locale.value.behavior[item.name] = {
            info: item.info,
            name: item.label
        };
        behaviorTree.forEach(menu => {
            if (menu.key === item.menu) {
                menu.children.push(item.name);
            }
        });
    });
}

const addMenu = function (menu, before) {
    if (!Array.isArray(menu)) {
        menu = [menu];
    }
    if (before) {
        menus.unshift(...menu);
    } else {
        menus.push(...menu);
    }
}

const addDragRule = function (dragRule, before) {
    if (!Array.isArray(dragRule)) {
        dragRule = [dragRule];
    }
    if (before) {
        dragRuleList.unshift(...dragRule);
    } else {
        dragRuleList.push(...dragRule);
    }
}

const install = function (Vue) {
    Vue.component('FcDesignerMobile', FcDesignerMobile);
};

FcDesignerMobile.install = install;
FcDesignerMobile.makeOptionsRule = makeOptionsRule;
FcDesignerMobile.formCreate = formCreate;
FcDesignerMobile.designerForm = designerForm;
FcDesignerMobile.component = addComponent;
FcDesignerMobile.setFormula = setFormula;
FcDesignerMobile.setBehavior = setBehavior;
FcDesignerMobile.useLocale = globalUseLocale;
FcDesignerMobile.copyTextToClipboard = copyTextToClipboard;
FcDesignerMobile.getInjectArg = getInjectArg;
FcDesignerMobile.localeOptions = localeOptions;
FcDesignerMobile.localeProps = localeProps;
FcDesignerMobile.makeRequiredRule = makeRequiredRule;
FcDesignerMobile.makeTreeOptions = makeTreeOptions;
FcDesignerMobile.makeTreeOptionsRule = makeTreeOptionsRule;
FcDesignerMobile.makeTitleRule = makeTitleRule;
FcDesignerMobile.makeDataRule = makeDataRule;
FcDesignerMobile.toJSON = toJSON;
FcDesignerMobile.loadjs = loadjs;
FcDesignerMobile.addDragRule = addDragRule;
FcDesignerMobile.addMenu = addMenu;
FcDesignerMobile.t = t;
FcDesignerMobile.utils = {
    copyTextToClipboard,
    getInjectArg,
    localeOptions,
    localeProps,
    makeOptionsRule,
    makeRequiredRule,
    makeTitleRule,
    makeDataRule,
    makeTreeOptions,
    makeTreeOptionsRule,
    toJSON
};

const minVersion = '3.2.22';

if (compareVersion(minVersion, formCreate.version) === 1) {
    console.error('Please use FormCreate version ' + minVersion + ' or greater, see https://github.com/xaboy/form-create.');
}

FcDesignerMobile.version = 'pro-5.7.2';

Object.keys(setting.extend.components).forEach(name => {
    addComponent(name, setting.extend.components[name], setting.componentViews[name]);
})

setting.updateDesigner(FcDesignerMobile);

export default FcDesignerMobile;

if (typeof window !== 'undefined') {
    window.FcDesignerMobile = FcDesignerMobile;
}

export {
    formCreate,
    designerForm,
    install,
    t,
    loadjs,
    copyTextToClipboard,
    getInjectArg,
    localeOptions,
    localeProps,
    makeOptionsRule,
    makeRequiredRule,
    makeTitleRule,
    makeDataRule,
    makeTreeOptions,
    makeTreeOptionsRule,
    addDragRule,
    addMenu,
    toJSON
};
