// +-----------------------------------------------------------------------
// | FormCreate商业版 [ 让表单设计更简单 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2018~2025 https://form-create.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed FormCreate商业版并不是自由软件，未经授权不得使用、修改或移除版权信息
// +----------------------------------------------------------------------
// | Author: FormCreate Team <admin@form-create.com>
// +----------------------------------------------------------------------
import formCreateMobile from '@form-create/vant';
import StepForm from '../components/stepForm/StepForm.vue';
import Popup from '../components/popup/Popup.vue';
import Table from '../components/table/Table.vue';
import TableForm from '../components/tableForm/TableForm.vue';
import Cell from '../components/cell/Cell.vue';
import Value from '../components/value/Value.vue';
import Slot from '../components/slotComponent/SlotComponent.vue';
import Json from '../components/jsonComponent/JsonComponent.vue';
import Echarts from '../components/echarts/Echarts.vue';
import SignaturePad from '../components/SignaturePad.vue';
import Id from '../components/Id.vue';
import FcCity from '../components/City.vue';
import FcTitle from '../components/aide/FcTitle.vue';
import FcMarkdown from '../components/aide/Markdown.vue';
import AudioBox from '../components/aide/AudioBox.vue';
import IframeBox from '../components/aide/IframeBox.vue';
import BarCodeBox from '../components/aide/BarCodeBox.vue';
import VideoBox from '../components/aide/VideoBox.vue';
import QrCodeBox from '../components/aide/QrCodeBox.vue';
import renderPreview from '../utils/preview';
import formulas from '../utils/formulas';
import useExtendApi from '../utils/extendApi';
import useExtendMessageApi from '../utils/extendMessageApi';
import useExtendPrintApi from '../utils/extendPrintApi';
import behaviorAttr from '../utils/behavior';
import easySlotsAttr from '../utils/easySlots';
import loadjs from '../utils/loadjs/loadjs';
import extend from '../extension/index';
import './mobile.css';
import '../style/icon.css';

formCreateMobile.parser().preview = renderPreview;

export function useAdvanced(formCreate) {
    Object.keys(formulas).forEach(k => {
        formCreate.setFormula(k, formulas[k]);
    });

    useExtendApi(formCreate);
    useExtendMessageApi(formCreate);
    useExtendPrintApi(formCreate);
    formCreate.register('behavior', behaviorAttr);
    formCreate.register('easySlots', easySlotsAttr);
}

useAdvanced(formCreateMobile);

formCreateMobile.component('FcSlot', Slot);
formCreateMobile.component('FcJson', Json);
formCreateMobile.component('StepForm', StepForm);
formCreateMobile.component('FcPopup', Popup);
formCreateMobile.component('FcTable', Table);
formCreateMobile.component('FcCell', Cell);
formCreateMobile.component('TableForm', TableForm);
formCreateMobile.component('FcValue', Value);
formCreateMobile.component('AudioBox', AudioBox);
formCreateMobile.component('VideoBox', VideoBox);
formCreateMobile.component('BarCodeBox', BarCodeBox);
formCreateMobile.component('IframeBox', IframeBox);
formCreateMobile.component('QrCodeBox', QrCodeBox);
formCreateMobile.component('SignaturePad', SignaturePad);
formCreateMobile.component('FcEcharts', Echarts);
formCreateMobile.component('FcTitle', FcTitle);
formCreateMobile.component('FcMarkdown', FcMarkdown);
formCreateMobile.component('FcCity', FcCity);
formCreateMobile.component('FcId', Id);
formCreateMobile.loadjs = loadjs;

Object.keys(extend.components).forEach(name => {
    formCreateMobile.component(name, extend.components[name]);
});

extend.updateFormCreate(formCreateMobile);

export default formCreateMobile;

