import {getInjectArg, localeOptions, localeProps} from '../../utils';

const name = 'fcPopup';

export default {
    name,
    icon: 'icon-dialog',
    label: '弹出层',
    drag: true,
    dragBtn: false,
    handleBtn: false,
    inside: false,
    mask: false,
    style: false,
    advanced: false,
    input: true,
    subForm: 'object',
    hiddenBaseField: ['title', 'info', 'formCreateCol>span', 'labelConfig', '_control'],
    languageKey: ['close', 'ok'],
    event: ['confirm', 'submit', 'validateFail', 'open', 'opened', 'close', 'closed', 'click', 'clickCloseIcon'],
    container: {
        formDataField: 'value',
        labelField: 'props.title',
    },
    loadRule(rule) {
        rule.children = rule.props.rule || [];
        if (rule.native == null) {
            rule.native = true;
        }
        if (rule.ignore == null) {
            rule.ignore = true;
        }
        delete rule.props.rule;
    },
    parseRule(rule) {
        rule.props.rule = rule.children || [];
        rule.children = [];
    },
    rule({t}) {
        return {
            type: name,
            props: {
                title: t('com.fcPopup.name'),
            },
            native: true,
            ignore: true,
            children: [],
        };
    },
    props(_, {t}) {
        return localeProps(t, name + '.props', [
            {
                type: 'input',
                field: 'title',
            },
            {
                type: 'select',
                field: 'position',
                title: '弹出位置',
                options: localeOptions(t, [
                    {
                        label: 'center',
                        value: 'center',
                    },
                    {
                        label: 'top',
                        value: 'top',
                    },
                    {
                        label: 'bottom',
                        value: 'bottom',
                    },
                    {
                        label: 'left',
                        value: 'left',
                    },
                    {
                        label: 'right',
                        value: 'right',
                    },
                ])
            },
            {
                type: 'switch',
                field: 'preview',
                title: t('form.previewMode')
            },
            {
                type: 'switch',
                field: 'disabled',
                title: t('props.disabled')
            },
            {
                type: 'switch',
                field: 'autoClose',
                value: true,
            },
            {
                type: 'switch',
                field: 'footer',
                value: true,
            },
            {
                type: 'FnInput',
                field: 'beforeClose',
                title: '关闭前的回调函数',
                props: {
                    body: true,
                    button: true,
                    fnx: true,
                    name: 'beforeClose',
                    args: [getInjectArg(t)],
                },
            }
        ]);
    }
};
