const label = 'Markdown';
const name = 'markdown';

export default {
    menu: 'aide',
    icon: 'icon-markdown',
    label,
    name,
    rule() {
        return {
            type: 'FcMarkdown',
            native: true,
            props: {
                content: '### 标题\n' +
                    '\n' +
                    '使用 # 号创建标题\n' +
                    '\n' +
                    '```\n' +
                    '# 一级标题\n' +
                    '## 二级标题\n' +
                    '### 三级标题\n' +
                    '```\n' +
                    '\n' +
                    '### 粗体\n' +
                    '\n' +
                    '使用 ** 包围文本\n' +
                    '\n' +
                    '```\n' +
                    '**粗体文本**\n' +
                    '```\n' +
                    '\n' +
                    '### 斜体\n' +
                    '\n' +
                    '使用 * 包围文本\n' +
                    '\n' +
                    '```\n' +
                    '*斜体文本*\n' +
                    '```\n' +
                    '\n' +
                    '### 删除线\n' +
                    '\n' +
                    '使用 ~~ 包围文本\n' +
                    '\n' +
                    '```\n' +
                    '~~删除线文本~~\n' +
                    '```\n' +
                    '\n' +
                    '### 链接\n' +
                    '\n' +
                    '使用 [文本](链接) 格式\n' +
                    '\n' +
                    '```\n' +
                    '[链接文本](https://example.com)\n' +
                    '```\n' +
                    '\n' +
                    '### 图片\n' +
                    '\n' +
                    '使用 ![描述|宽度x高度](图片链接) 格式\n' +
                    '\n' +
                    '```\n' +
                    '![图片固定|400x300](https://example.com/image.jpg)\n' +
                    '![图片](https://example.com/image.jpg)\n' +
                    '```\n' +
                    '\n' +
                    '### 代码块\n' +
                    '\n' +
                    '使用 ``` 包围代码\n' +
                    '\n' +
                    '````\n' +
                    '```js\n' +
                    'function hello() {\n' +
                    '  console.log(\'Hello\');\n' +
                    '}\n' +
                    '```\n' +
                    '````\n' +
                    '\n' +
                    '### 行内代码\n' +
                    '\n' +
                    '使用 ` 包围代码\n' +
                    '\n' +
                    '```\n' +
                    '`行内代码`\n' +
                    '```\n' +
                    '\n' +
                    '### 引用\n' +
                    '\n' +
                    '使用 > 开始引用\n' +
                    '\n' +
                    '```\n' +
                    '> 这是一段引用文本\n' +
                    '```\n' +
                    '\n' +
                    '### 无序列表\n' +
                    '\n' +
                    '使用 - 开始列表项\n' +
                    '\n' +
                    '```\n' +
                    '- 项目1\n' +
                    '- 项目2\n' +
                    '- 项目3\n' +
                    '```\n' +
                    '\n' +
                    '### 有序列表\n' +
                    '\n' +
                    '使用 1. 开始列表项\n' +
                    '\n' +
                    '```\n' +
                    '1. 第一项\n' +
                    '2. 第二项\n' +
                    '3. 第三项\n' +
                    '```\n' +
                    '\n' +
                    '### 表格\n' +
                    '\n' +
                    '使用 | 分隔列\n' +
                    '\n' +
                    '```\n' +
                    '| 左对齐 | 居中对齐 | 右对齐 |\n' +
                    '|:-------|:-------:|-------:|\n' +
                    '| 数据1 | 数据2 | 数据3 |\n' +
                    '```\n' +
                    '\n' +
                    '### 水平分割线\n' +
                    '\n' +
                    '使用 --- 创建分割线\n' +
                    '\n' +
                    '```\n' +
                    '---\n' +
                    '```\n' +
                    '\n' +
                    '### 强制换行\n' +
                    '\n' +
                    '使用 <br/> 标签实现多次换行\n' +
                    '\n' +
                    '```\n' +
                    '第一行<br/><br/>第三行\n' +
                    '```\n'
            }
        };
    },
    props(_, {t}) {
        return [
            {
                type: 'HtmlEditor',
                field: 'content',
                title: t('props.content'),
                props: {
                    text: true,
                }
            }
        ];
    }
};
