// +-----------------------------------------------------------------------
// | FormCreate商业版 [ 让表单设计更简单 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2018~2025 https://form-create.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed FormCreate商业版并不是自由软件，未经授权不得使用、修改或移除版权信息
// +----------------------------------------------------------------------
// | Author: FormCreate Team <admin@form-create.com>
// +----------------------------------------------------------------------
import input from './rule/input';
import textarea from './rule/textarea';
import password from './rule/password';
import stepper from './rule/stepper';
import checkbox from './rule/checkbox';
import radio from './rule/radio';
import select from './rule/select';
import _switch from './rule/switch';
import rate from './rule/rate';
import date from './rule/date';
import time from './rule/time';
import cascader from './rule/cascader';
import slider from './rule/slider';
import calendar from './rule/calendar';
import calendarRange from './rule/calendarRange';
import uploader from './rule/uploader';
import value from './rule/value';
import group from './rule/group';
import subForm from './rule/subForm';
import tableForm from './rule/tableForm';
import tableFormColumn from './rule/tableFormColumn';
import tag from './rule/tag';
import stepForm from './rule/stepForm';
import stepFormItem from './rule/stepFormItem';
import noticeBar from './rule/noticeBar';
import divider from './rule/divider';
import collapse from './rule/collapse';
import collapseItem from './rule/collapseItem';
import space from './rule/space';
import row from './rule/row';
import col from './rule/col';
import button from './rule/button';
import tabs from './rule/tabs';
import tabPane from './rule/tabPane';
import cell from './rule/cell';
import cellGroup from './rule/cellGroup';
import cell2 from './rule/cell2';
import text from './rule/text';
import html from './rule/html';
import table from './rule/table';
import icon from './rule/icon';
import popup from './rule/popup';
import col3 from './template/col3';
import chineseAmount from './template/chineseAmount';
import slot from './rule/slot';
import json from './rule/json';
import image from './rule/image';
import flex2 from './rule/flex2';
import formItem from './rule/formItem';
import table43 from './template/table43';
import audio from './rule/audio';
import video from './rule/video';
import barCode from './rule/barCode';
import iframe from './rule/iframe';
import qrCodeBox from './rule/qrCodeBox';
import title from './rule/title';
import id from './rule/id';
import city from './rule/city';
import markdown from './rule/markdown';
import signaturePad from './rule/signaturePad';
import lineChart from './rule/charts/lineChart';
import areaChart from './rule/charts/areaChart';
import barChart from './rule/charts/barChart';
import stripeChart from './rule/charts/stripeChart';
import pieChart from './rule/charts/pieChart';
import funnelChart from './rule/charts/funnelChart';
import gaugeChart from './rule/charts/gaugeChart';
import radarChart from './rule/charts/radarChart';
import scatterChart from './rule/charts/scatterChart';
import customChart from './rule/charts/customChart';

const ruleList = [
    input, textarea, password, stepper, radio, checkbox, select, _switch, rate, time, date, cascader, calendar, calendarRange, slider, uploader, city, id, signaturePad, value,
    group, subForm, stepForm, stepFormItem, tableForm, tableFormColumn,
    slot, json, formItem,
    noticeBar, button, title, text, html, divider, tag, image, audio, video, barCode, iframe, qrCodeBox, markdown, icon,
    lineChart, areaChart, barChart, stripeChart, pieChart, funnelChart, gaugeChart, radarChart, scatterChart, customChart,
    row, col, table, flex2, cell,
    tabs, tabPane, space, collapse, collapseItem, cellGroup, cell2,

    col3, table43, chineseAmount,
    popup,
];

export default ruleList;

export function defaultDrag(rule) {
    return {
        icon: rule.field ? 'icon-input' : 'icon-cell',
        label: rule.field || rule.type,
        name: '_',
        mask: true,
        handleBtn: ['delete'],
        rule() {
            return rule;
        },
        props() {
            return [];
        }
    }
}
