module.exports = {
    'env': {
        'browser': true,
        'node': true,
        'es6': true,
        'jest': true,
        'commonjs': true
    },
    'extends': [
        'eslint:recommended',
        'plugin:vue/essential',
    ],
    'parserOptions': {
        'ecmaVersion': 2018,
        'sourceType': 'module',
        'ecmaFeatures': {
            'experimentalObjectRestSpread': true,
            'jsx': true
        },
        'parser': 'babel-eslint',
    },
    'plugins': [
        'vue'
    ],
    'rules': {
        'indent': [
            'error',
            4
        ],
        'quotes': [
            'error',
            'single'
        ],
        'block-spacing': 'error',
        'no-unused-vars': 'off',
        'no-irregular-whitespace': 'off',
        'no-useless-escape': 'off',
        'no-empty': 'off',
        'object-curly-spacing': 'error',
        'no-console': 'warn',
        'vue/valid-v-model': 'off',
        'vue/no-template-key': 'off',
        'vue/valid-v-for': 'off',
        'vue/require-v-for-key': 'off',
        'vue/no-v-for-template-key': 'off',
        'vue/no-mutating-props': 'off',
        'vue/no-dupe-keys': 'off',
        'vue/no-unused-components': 'warn',
        'vue/no-v-model-argument': 'off',
        'vue/no-unused-vars': 'off',
    }
};
