import is from '@form-create/utils/lib/type';

const findTreeLabel = function (find, data, key) {
    data.forEach(v => {
        if (find.indexOf(v[key || 'id']) > -1) {
            find.splice(find.indexOf(v[key || 'id']), 1, v.label || v.text);
        }
        if (is.trueArray(v.children)) {
            findTreeLabel(find, v.children, key);
        }
    });
    return find;
};

const findCheckboxLabel = function (find, data) {
    data.forEach(v => {
        if (find.indexOf(v.value) > -1) {
            find[find.indexOf(v.value)] = v.label || v.text;
        }
    });
    return find;
};

function toArray(val) {
    if (!val) {
        return [];
    } else if (!Array.isArray(val)) {
        return [val];
    }
    return val;
}

export default function renderPreview(_, ctx) {
    let val = ctx.rule.value;
    const h = (...args) => ctx.$render.vNode.h(...args);
    const type = ctx.type;
    const subForm = ctx.$handle.subForm[ctx.id];
    const readMode = ctx.prop.readMode;
    if (readMode === false || readMode === 'custom' || !ctx.input || ctx.rule.subForm || (Array.isArray(subForm) ? subForm.length : subForm) || ['fcGroup', 'fcSubForm', 'tableForm', 'fcJson', 'stepForm', 'nestedTableForm', 'infiniteTableForm', 'fcUploader', 'fcDialog', 'fcDrawer', 'fcPopup'].indexOf(ctx.trueType) > -1) {
        return ctx.parser.render(_, ctx);
    }
    if (['radio', 'select', 'checkbox'].indexOf(type) > -1) {
        val = findCheckboxLabel([...toArray(val)], ctx.prop.props.options || ctx.prop.props.formCreateInject.options || []).join(', ');
    } else if (['timePicker', 'datePicker', 'slider'].indexOf(type) > -1) {
        val = Array.isArray(val) ? val.join(' - ') : val;
    } else if (type === 'cascader') {
        val = [...toArray(val)];
        if (!Array.isArray(val[0])) {
            val = [val];
        }
        val = val.map(item => {
            return findTreeLabel(item, ctx.prop.props.options || ctx.prop.props.formCreateInject.options || [], 'value').join('/');
        }).join(', ');
    } else if (type === 'fcEditor' || readMode === 'html') {
        return h('div', {innerHTML: val});
    } else if (readMode === 'image') {
        val = toArray(val);
        return h('div', {class: '_fc-upload'}, val.map(function (src) {
            return h('div', {class: '_fc-upload-preview'}, [
                h('van-image', {src: src, fit: 'cover'})
            ]);
        }));
    }  else if (type === 'signaturePad' && val) {
        return h('van-image', {src: val, fit: 'cover',style: {height: '90px'}});
    } else if (typeof val === 'boolean' || type === 'switch') {
        val = val ? '是' : '否';
    }
    return h('span', {class: '_fc-read-view', style: {whiteSpace: 'pre-line'}}, ['' + (val == null ? '' : val)]);
}